/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsMajorVersion;
import org.apache.doris.external.elasticsearch.EsNodeInfo;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class EsRestClient {
    private static final Logger LOG = LogManager.getLogger(EsRestClient.class);
    private ObjectMapper mapper = new ObjectMapper();
    private static OkHttpClient networkClient = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).build();
    private static OkHttpClient sslNetworkClient;
    private Request.Builder builder;
    private String[] nodes;
    private String currentNode;
    private int currentNodeIndex;
    private boolean httpSslEnable;

    public EsRestClient(String[] nodes, String authUser, String authPassword, boolean httpSslEnable) {
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, false);
        this.mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, false);
        this.currentNodeIndex = 0;
        this.nodes = nodes;
        this.builder = new Request.Builder();
        if (!Strings.isEmpty((CharSequence)authUser) && !Strings.isEmpty((CharSequence)authPassword)) {
            this.builder.addHeader("Authorization", Credentials.basic((String)authUser, (String)authPassword));
        }
        this.currentNode = nodes[this.currentNodeIndex];
        this.httpSslEnable = httpSslEnable;
    }

    private void selectNextNode() {
        ++this.currentNodeIndex;
        if (this.currentNodeIndex >= this.nodes.length) {
            this.currentNodeIndex = 0;
        }
        this.currentNode = this.nodes[this.currentNodeIndex];
    }

    public Map<String, EsNodeInfo> getHttpNodes() throws DorisEsException {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        if (nodesData == null) {
            return Collections.emptyMap();
        }
        HashMap<String, EsNodeInfo> nodesMap = new HashMap<String, EsNodeInfo>();
        for (Map.Entry entry : nodesData.entrySet()) {
            EsNodeInfo node = new EsNodeInfo((String)entry.getKey(), (Map)entry.getValue(), this.httpSslEnable);
            if (!node.hasHttp()) continue;
            nodesMap.put(node.getId(), node);
        }
        return nodesMap;
    }

    public EsMajorVersion version() throws DorisEsException {
        Map result = (Map)this.get("/", null);
        if (result == null) {
            throw new DorisEsException("Unable to retrieve ES main cluster info.");
        }
        Map versionBody = (Map)result.get("version");
        return EsMajorVersion.parse((String)versionBody.get("number"));
    }

    public String getMapping(String indexName) throws DorisEsException {
        String path = indexName + "/_mapping";
        String indexMapping = this.execute(path);
        if (indexMapping == null) {
            throw new DorisEsException("index[" + indexName + "] not found");
        }
        return indexMapping;
    }

    public EsShardPartitions searchShards(String indexName) throws DorisEsException {
        String path = indexName + "/_search_shards";
        String searchShards = this.execute(path);
        if (searchShards == null) {
            throw new DorisEsException("request index [" + indexName + "] search_shards failure");
        }
        return EsShardPartitions.findShardPartitions(indexName, searchShards);
    }

    private synchronized OkHttpClient getOrCreateSslNetworkClient() {
        if (sslNetworkClient == null) {
            sslNetworkClient = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(EsRestClient.createSSLSocketFactory(), (X509TrustManager)new TrustAllCerts()).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier()).build();
        }
        return sslNetworkClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(String path) throws DorisEsException {
        int retrySize = this.nodes.length;
        DorisEsException scratchExceptionForThrow = null;
        OkHttpClient httpClient = this.httpSslEnable ? this.getOrCreateSslNetworkClient() : networkClient;
        for (int i = 0; i < retrySize; ++i) {
            this.currentNode = this.currentNode.trim();
            if (!this.currentNode.startsWith("http://") && !this.currentNode.startsWith("https://")) {
                this.currentNode = "http://" + this.currentNode;
            }
            Request request = this.builder.get().url(this.currentNode + "/" + path).build();
            Response response = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace("es rest client request URL: {}", (Object)(this.currentNode + "/" + path));
            }
            try {
                response = httpClient.newCall(request).execute();
                if (response.isSuccessful()) {
                    String string = response.body().string();
                    return string;
                }
            }
            catch (IOException e) {
                LOG.warn("request node [{}] [{}] failures {}, try next nodes", (Object)this.currentNode, (Object)path, (Object)e);
                scratchExceptionForThrow = new DorisEsException(e.getMessage());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            this.selectNextNode();
        }
        LOG.warn("try all nodes [{}], no other nodes left", (Object[])this.nodes);
        if (scratchExceptionForThrow != null) {
            throw scratchExceptionForThrow;
        }
        return null;
    }

    public <T> T get(String q, String key) throws DorisEsException {
        return this.parseContent(this.execute(q), key);
    }

    private <T> T parseContent(String response, String key) {
        Map map = Collections.emptyMap();
        try {
            JsonParser jsonParser = this.mapper.getJsonFactory().createJsonParser(response);
            map = (Map)this.mapper.readValue(jsonParser, Map.class);
        }
        catch (IOException ex) {
            LOG.error("parse es response failure: [{}]", (Object)response);
            throw new DorisEsException(ex.getMessage());
        }
        return (T)(key != null ? map.get(key) : map);
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            throw new DorisEsException("Errors happens when create ssl socket");
        }
        return ssfFactory;
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAllCerts
    implements X509TrustManager {
        private TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

