/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsRepository
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(EsRepository.class);
    private Map<Long, EsTable> esTables = Maps.newConcurrentMap();
    private Map<Long, EsRestClient> esClients = Maps.newConcurrentMap();

    public EsRepository() {
        super("es repository", Config.es_state_sync_interval_second * 1000L);
    }

    public void registerTable(EsTable esTable) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.esTables.put(esTable.getId(), esTable);
        this.esClients.put(esTable.getId(), new EsRestClient(esTable.getSeeds(), esTable.getUserName(), esTable.getPasswd(), esTable.isHttpSslEnabled()));
        LOG.info("register a new table [{}] to sync list", (Object)esTable);
    }

    public void deRegisterTable(long tableId) {
        this.esTables.remove(tableId);
        this.esClients.remove(tableId);
        LOG.info("deregister table [{}] from sync list", (Object)tableId);
    }

    @Override
    protected void runAfterCatalogReady() {
        for (EsTable esTable : this.esTables.values()) {
            try {
                esTable.syncTableMetaData(this.esClients.get(esTable.getId()));
            }
            catch (Throwable e) {
                LOG.warn("Exception happens when fetch index [{}] meta data from remote es cluster", (Object)esTable.getName(), (Object)e);
                esTable.setEsTablePartitions(null);
                esTable.setLastMetaDataSyncException(e);
            }
        }
    }

    public void loadTableFromCatalog() {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        List<Long> dbIds = Catalog.getCurrentCatalog().getDbIds();
        for (Long dbId : dbIds) {
            Database database = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (database == null) continue;
            List<Table> tables = database.getTables();
            for (Table table : tables) {
                if (table.getType() != Table.TableType.ELASTICSEARCH) continue;
                this.registerTable((EsTable)table);
            }
        }
    }
}

