/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.util.List;
import java.util.Map;
import org.apache.doris.external.elasticsearch.EsMajorVersion;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsNodeInfo {
    private final String id;
    private final String name;
    private final String host;
    private final String ip;
    private TNetworkAddress publishAddress;
    private final boolean hasHttp;
    private final boolean isClient;
    private final boolean isData;
    private final boolean isIngest;
    private boolean hasThrift;
    private TNetworkAddress thriftAddress;
    private static final Logger LOG = LogManager.getLogger(EsNodeInfo.class);

    public EsNodeInfo(String id, Map<String, Object> map, boolean httpSslEnabled) {
        this.id = id;
        EsMajorVersion version = EsMajorVersion.parse((String)map.get("version"));
        this.name = (String)map.get("name");
        this.host = (String)map.get("host");
        this.ip = (String)map.get("ip");
        if (version.before(EsMajorVersion.V_5_X)) {
            Map attributes = (Map)map.get("attributes");
            if (attributes == null) {
                this.isClient = false;
                this.isData = true;
            } else {
                String data = (String)attributes.get("data");
                this.isClient = data == null ? true : !Boolean.parseBoolean(data);
                this.isData = data == null ? true : Boolean.parseBoolean(data);
            }
            this.isIngest = false;
        } else {
            List roles = (List)map.get("roles");
            this.isClient = !roles.contains("data");
            this.isData = roles.contains("data");
            this.isIngest = roles.contains("ingest");
        }
        Map httpMap = (Map)map.get("http");
        if (httpMap != null) {
            String address = (String)httpMap.get("publish_address");
            if (address != null) {
                address = address.substring(address.lastIndexOf(47) + 1);
                String[] scratch = address.split(":");
                this.publishAddress = new TNetworkAddress((httpSslEnabled ? "https://" : "") + scratch[0], Integer.parseInt(scratch[1]));
                this.hasHttp = true;
            } else {
                this.publishAddress = null;
                this.hasHttp = false;
            }
        } else {
            this.publishAddress = null;
            this.hasHttp = false;
        }
        Map attributesMap = (Map)map.get("attributes");
        if (attributesMap != null) {
            String thriftPortStr = (String)attributesMap.get("thrift_port");
            if (thriftPortStr != null) {
                try {
                    int thriftPort = Integer.valueOf(thriftPortStr);
                    this.hasThrift = true;
                    this.thriftAddress = new TNetworkAddress(this.ip, thriftPort);
                }
                catch (Exception e) {
                    this.hasThrift = false;
                }
            } else {
                this.hasThrift = false;
            }
        } else {
            this.hasThrift = false;
        }
    }

    public EsNodeInfo(String id, String seed) {
        String remoteHost;
        this.id = id;
        String[] scratch = seed.split(":");
        int port = 80;
        if (scratch.length == 3) {
            port = Integer.parseInt(scratch[2]);
        }
        this.name = remoteHost = scratch[0] + ":" + scratch[1];
        this.host = remoteHost;
        this.ip = remoteHost;
        this.isClient = true;
        this.isData = true;
        this.isIngest = true;
        this.publishAddress = new TNetworkAddress(remoteHost, port);
        this.hasHttp = true;
    }

    public boolean hasHttp() {
        return this.hasHttp;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean isData() {
        return this.isData;
    }

    public boolean isIngest() {
        return this.isIngest;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public TNetworkAddress getPublishAddress() {
        return this.publishAddress;
    }

    public boolean isHasThrift() {
        return this.hasThrift;
    }

    public TNetworkAddress getThriftAddress() {
        return this.thriftAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsNodeInfo nodeInfo = (EsNodeInfo)o;
        if (this.hasHttp != nodeInfo.hasHttp) {
            return false;
        }
        if (this.isClient != nodeInfo.isClient) {
            return false;
        }
        if (this.isData != nodeInfo.isData) {
            return false;
        }
        if (!this.id.equals(nodeInfo.id)) {
            return false;
        }
        if (!this.name.equals(nodeInfo.name)) {
            return false;
        }
        if (!this.host.equals(nodeInfo.host)) {
            return false;
        }
        if (!this.ip.equals(nodeInfo.ip)) {
            return false;
        }
        if (this.hasThrift != nodeInfo.hasThrift) {
            return false;
        }
        return (this.publishAddress != null ? this.publishAddress.equals(nodeInfo.publishAddress) : nodeInfo.publishAddress == null) && (this.thriftAddress != null ? this.thriftAddress.equals(nodeInfo.thriftAddress) : nodeInfo.thriftAddress == null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.ip.hashCode();
        result = 31 * result + (this.publishAddress != null ? this.publishAddress.hashCode() : 0);
        result = 31 * result + (this.thriftAddress != null ? this.thriftAddress.hashCode() : 0);
        result = 31 * result + (this.hasHttp ? 1 : 0);
        result = 31 * result + (this.hasThrift ? 1 : 0);
        result = 31 * result + (this.isClient ? 1 : 0);
        result = 31 * result + (this.isData ? 1 : 0);
        return result;
    }

    public String toString() {
        return "EsNodeInfo{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", ip='" + this.ip + '\'' + ", publishAddress=" + this.publishAddress + ", hasHttp=" + this.hasHttp + ", isClient=" + this.isClient + ", isData=" + this.isData + ", isIngest=" + this.isIngest + ", hasThrift=" + this.hasThrift + ", thriftAddress=" + this.thriftAddress + '}';
    }
}

