/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.external.elasticsearch;

import java.util.LinkedList;
import java.util.List;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.external.elasticsearch.DorisEsException;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.doris.external.elasticsearch.MappingPhase;
import org.apache.doris.external.elasticsearch.PartitionPhase;
import org.apache.doris.external.elasticsearch.SearchContext;
import org.apache.doris.external.elasticsearch.SearchPhase;
import org.apache.doris.external.elasticsearch.VersionPhase;

public class EsMetaStateTracker {
    private List<SearchPhase> builtinSearchPhase = new LinkedList<SearchPhase>();
    private SearchContext searchContext;

    public EsMetaStateTracker(EsRestClient client, EsTable esTable) {
        this.builtinSearchPhase.add(new VersionPhase(client));
        this.builtinSearchPhase.add(new MappingPhase(client));
        this.builtinSearchPhase.add(new PartitionPhase(client));
        this.searchContext = new SearchContext(esTable);
    }

    public SearchContext searchContext() {
        return this.searchContext;
    }

    public void run() throws DorisEsException {
        for (SearchPhase searchPhase : this.builtinSearchPhase) {
            searchPhase.preProcess(this.searchContext);
            searchPhase.execute(this.searchContext);
            searchPhase.postProcess(this.searchContext);
        }
    }
}

