/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.deploy.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.deploy.DeployManager;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFileDeployManager
extends DeployManager {
    private static final Logger LOG = LogManager.getLogger(LocalFileDeployManager.class);
    public static final String ENV_APP_NAMESPACE = "APP_NAMESPACE";
    public static final String ENV_FE_SERVICE = "FE_SERVICE";
    public static final String ENV_FE_OBSERVER_SERVICE = "FE_OBSERVER_SERVICE";
    public static final String ENV_BE_SERVICE = "BE_SERVICE";
    public static final String ENV_BROKER_SERVICE = "BROKER_SERVICE";
    public static final String ENV_BROKER_NAME = "BROKER_NAME";
    private String clusterInfoFile;

    public LocalFileDeployManager(Catalog catalog, long intervalMs) {
        super(catalog, intervalMs);
        this.initEnvVariables(ENV_FE_SERVICE, ENV_FE_OBSERVER_SERVICE, ENV_BE_SERVICE, ENV_BROKER_SERVICE);
    }

    @Override
    protected void initEnvVariables(String envElectableFeServiceGroup, String envObserverFeServiceGroup, String envBackendServiceGroup, String envBrokerServiceGroup) {
        super.initEnvVariables(envElectableFeServiceGroup, envObserverFeServiceGroup, envBackendServiceGroup, envBrokerServiceGroup);
        this.clusterInfoFile = Strings.nullToEmpty((String)System.getenv(ENV_APP_NAMESPACE));
        if (Strings.isNullOrEmpty((String)this.clusterInfoFile)) {
            LOG.error("failed get cluster info file name: APP_NAMESPACE");
            System.exit(-1);
        }
        LOG.info("get cluster info file name: {}", (Object)this.clusterInfoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<String, Integer>> getGroupHostPorts(String groupName) {
        List<Pair<String, Integer>> list;
        ArrayList result = Lists.newArrayList();
        LOG.info("begin to get group: {} from file: {}", (Object)groupName, (Object)this.clusterInfoFile);
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        BufferedReader bufferedReader = null;
        try {
            FileInputStream stream = new FileInputStream(this.clusterInfoFile);
            channel = stream.getChannel();
            lock = ((FileChannel)channel).lock(0L, Long.MAX_VALUE, true);
            bufferedReader = new BufferedReader(new InputStreamReader(stream));
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                String[] endpoints;
                if (!str.startsWith(groupName)) continue;
                LOG.debug("read line: {}", (Object)str);
                String[] parts = str.split("=");
                if (parts.length != 2 || Strings.isNullOrEmpty((String)parts[1])) {
                    ArrayList arrayList = result;
                    return arrayList;
                }
                String endpointList = parts[1];
                for (String endpoint : endpoints = endpointList.split(",")) {
                    Pair<String, Integer> hostPorts = SystemInfoService.validateHostAndPort(endpoint);
                    result.add(hostPorts);
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("file not found", (Throwable)e);
            list = null;
            return list;
        }
        catch (IOException e) {
            LOG.warn("failed to read file", (Throwable)e);
            list = null;
            return list;
        }
        catch (AnalysisException e) {
            LOG.warn("failed to parse endpoint", (Throwable)e);
            list = null;
            return list;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOG.warn("failed to close buffered reader after reading file: {}", (Object)this.clusterInfoFile, (Object)e);
                }
            }
            if (lock != null && channel.isOpen()) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LOG.warn("failed to release lock after reading file: {}", (Object)this.clusterInfoFile, (Object)e);
                }
            }
            if (channel != null && channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LOG.warn("failed to close channel after reading file: {}", (Object)this.clusterInfoFile, (Object)e);
                }
            }
        }
        LOG.info("get hosts from {}: {}", (Object)groupName, (Object)result);
        return result;
    }

    @Override
    protected Map<String, List<Pair<String, Integer>>> getBrokerGroupHostPorts() {
        List<Pair<String, Integer>> hostPorts = this.getGroupHostPorts(this.brokerServiceGroup);
        if (hostPorts == null) {
            return null;
        }
        String brokerName = System.getenv(ENV_BROKER_NAME);
        if (Strings.isNullOrEmpty((String)brokerName)) {
            LOG.error("failed to get broker name from env: {}", (Object)ENV_BROKER_NAME);
            System.exit(-1);
        }
        HashMap brokers = Maps.newHashMap();
        brokers.put(brokerName, hostPorts);
        LOG.info("get brokers from file: {}", (Object)brokers);
        return brokers;
    }
}

