/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.deploy.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.deploy.DeployManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class K8sDeployManager
extends DeployManager {
    private static final Logger LOG = LogManager.getLogger(K8sDeployManager.class);
    public static final String ENV_APP_NAMESPACE = "APP_NAMESPACE";
    public static final String ENV_FE_SERVICE = "FE_SERVICE";
    public static final String ENV_FE_OBSERVER_SERVICE = "FE_OBSERVER_SERVICE";
    public static final String ENV_BE_SERVICE = "BE_SERVICE";
    public static final String ENV_BROKER_SERVICE = "BROKER_SERVICE";
    public static final String ENV_BROKER_NAME = "BROKER_NAME";
    public static final String FE_PORT = "edit-log-port";
    public static final String BE_PORT = "heartbeat-port";
    public static final String BROKER_PORT = "broker-port";
    private String appNamespace;
    private KubernetesClient client = null;
    public static final String K8S_CA_CERT_FILE = "cce-ca.pem";
    public static final String K8S_CLIENT_CERT_FILE = "cce-admin.pem";
    public static final String K8S_CLIENT_KEY_FILE = "cce-admin-key.pem";
    public static final String TEST_MASTER_URL = "https://127.0.0.1:1111/";
    public static final String TEST_NAMESPACE = "default";
    public static final String TEST_SERVICENAME = "palo-fe";

    public K8sDeployManager(Catalog catalog, long intervalMs) {
        super(catalog, intervalMs);
        this.initEnvVariables(ENV_FE_SERVICE, ENV_FE_OBSERVER_SERVICE, ENV_BE_SERVICE, ENV_BROKER_SERVICE);
    }

    @Override
    protected void initEnvVariables(String envElectableFeServiceGroup, String envObserverFeServiceGroup, String envBackendServiceGroup, String envBrokerServiceGroup) {
        super.initEnvVariables(envElectableFeServiceGroup, envObserverFeServiceGroup, envBackendServiceGroup, envBrokerServiceGroup);
        this.appNamespace = Strings.nullToEmpty((String)System.getenv(ENV_APP_NAMESPACE));
        if (Strings.isNullOrEmpty((String)this.appNamespace)) {
            LOG.error("failed to init namespace: APP_NAMESPACE");
            System.exit(-1);
        }
        LOG.info("get namespace: {}", (Object)this.appNamespace);
    }

    @Override
    protected List<Pair<String, Integer>> getGroupHostPorts(String groupName) {
        String portName = null;
        if (groupName.equals(this.electableFeServiceGroup)) {
            portName = FE_PORT;
        } else if (groupName.equals(this.observerFeServiceGroup)) {
            portName = FE_PORT;
        } else if (groupName.equals(this.backendServiceGroup)) {
            portName = BE_PORT;
        } else if (groupName.equals(this.brokerServiceGroup)) {
            portName = BROKER_PORT;
        } else {
            LOG.warn("unknown service group name: {}", (Object)groupName);
            return null;
        }
        Preconditions.checkNotNull((Object)this.appNamespace);
        Preconditions.checkNotNull((Object)portName);
        Endpoints endpoints = null;
        try {
            endpoints = this.endpoints(this.appNamespace, groupName);
        }
        catch (Exception e) {
            LOG.warn("encounter exception when get endpoint from namespace {}, service: {}", (Object)this.appNamespace, (Object)groupName, (Object)e);
            return null;
        }
        if (endpoints == null) {
            LOG.warn("get null endpoints of namespace {} in service: {}", (Object)this.appNamespace, (Object)groupName);
            return null;
        }
        ArrayList result = Lists.newArrayList();
        List subsets = endpoints.getSubsets();
        for (EndpointSubset subset : subsets) {
            Integer port = -1;
            List ports = subset.getPorts();
            for (EndpointPort eport : ports) {
                if (!eport.getName().equals(portName)) continue;
                port = eport.getPort();
                break;
            }
            if (port == -1) {
                LOG.warn("failed to get {} port", (Object)portName);
                return null;
            }
            List addrs = subset.getAddresses();
            for (EndpointAddress eaddr : addrs) {
                result.add(Pair.create(eaddr.getIp(), port));
            }
        }
        LOG.info("get host port from group: {}: {}", (Object)groupName, (Object)result);
        return result;
    }

    @Override
    protected Map<String, List<Pair<String, Integer>>> getBrokerGroupHostPorts() {
        List<Pair<String, Integer>> hostPorts = this.getGroupHostPorts(this.brokerServiceGroup);
        if (hostPorts == null) {
            return null;
        }
        String brokerName = System.getenv(ENV_BROKER_NAME);
        if (Strings.isNullOrEmpty((String)brokerName)) {
            LOG.error("failed to get broker name from env: {}", (Object)ENV_BROKER_NAME);
            System.exit(-1);
        }
        HashMap brokers = Maps.newHashMap();
        brokers.put(brokerName, hostPorts);
        LOG.info("get brokers from k8s: {}", (Object)brokers);
        return brokers;
    }

    private Endpoints endpoints(String namespace, String serviceName) throws Exception {
        return (Endpoints)((Resource)((NonNamespaceOperation)this.client().endpoints().inNamespace(namespace)).withName(serviceName)).get();
    }

    private synchronized KubernetesClient client() {
        if (this.client != null) {
            return this.client;
        }
        try {
            if (Config.with_k8s_certs) {
                ConfigBuilder configBuilder = (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(TEST_MASTER_URL)).withTrustCerts(true)).withCaCertFile(K8S_CA_CERT_FILE)).withClientCertFile(K8S_CLIENT_CERT_FILE)).withClientKeyFile(K8S_CLIENT_KEY_FILE);
                this.client = new DefaultKubernetesClient(configBuilder.build());
            } else {
                this.client = new DefaultKubernetesClient();
            }
        }
        catch (KubernetesClientException e) {
            LOG.warn("failed to get k8s client.", (Throwable)e);
            throw e;
        }
        return this.client;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

