/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.deploy.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.Util;
import org.apache.doris.deploy.DeployManager;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class AmbariDeployManager
extends DeployManager {
    private static final Logger LOG = LogManager.getLogger(AmbariDeployManager.class);
    public static final String ENV_AUTH_INFO = "ENV_AUTH_INFO";
    public static final String ENV_AMBARI_HOST = "ENV_AMBARI_HOST";
    public static final String ENV_AMBARI_PORT = "ENV_AMBARI_PORT";
    public static final String ENV_AMBARI_CLUSTER = "ENV_AMBARI_CLUSTER";
    public static final String ENV_AMBARI_SERVICE_NAME = "ENV_AMBARI_SERVICE_NAME";
    public static final String ENV_AMBARI_FE_COMPONENTS = "ENV_AMBARI_FE_COMPONENTS";
    public static final String ENV_AMBARI_BE_COMPONENTS = "ENV_AMBARI_BE_COMPONENTS";
    public static final String ENV_AMBARI_BROKER_COMPONENTS = "ENV_AMBARI_BROKER_COMPONENTS";
    public static final String ENV_AMBARI_FE_COMPONENTS_CONFIG = "ENV_AMBARI_FE_COMPONENTS_CONFIG";
    public static final String ENV_AMBARI_BE_COMPONENTS_CONFIG = "ENV_AMBARI_BE_COMPONENTS_CONFIG";
    public static final String ENV_AMBARI_BROKER_COMPONENTS_CONFIG = "ENV_AMBARI_BROKER_COMPONENTS_CONFIG";
    public static final String URL_BLUEPRINT = "http://%s/api/v1/clusters/%s?format=blueprint";
    public static final String URL_COMPONENTS = "http://%s/api/v1/clusters/%s/services/%s/components/%s";
    public static final String KEY_BE_HEARTBEAT_PORT = "be_heartbeat_service_port";
    public static final String KEY_FE_EDIT_LOG_PORT = "fe_edit_log_port";
    public static final String KEY_BROKER_IPC_PORT = "broker_ipc_port";
    public static final String KEY_BROKER_NAME = "broker_name";
    public static final String KEY_HOST_COMPONENTS = "host_components";
    public static final String KEY_HOST_ROLES = "HostRoles";
    public static final String KEY_HOST_NAME = "host_name";
    private String authInfo;
    private String encodedAuthInfo;
    private String ambariUrl;
    private String clusterName;
    private String serviceName;
    private String blueprintUrl;
    private String feConfigNode;
    private String beConfigNode;
    private String brokerConfigNode;
    private String blueprintJson;

    public AmbariDeployManager(Catalog catalog, long intervalMs) {
        super(catalog, intervalMs);
        this.initEnvVariables(ENV_AMBARI_FE_COMPONENTS, "", ENV_AMBARI_BE_COMPONENTS, ENV_AMBARI_BROKER_COMPONENTS);
    }

    public AmbariDeployManager() {
        super((Catalog)null, -1L);
    }

    @Override
    protected void initEnvVariables(String envElectableFeServiceGroup, String envObserverFeServiceGroup, String envBackendServiceGroup, String envBrokerServiceGroup) {
        super.initEnvVariables(envElectableFeServiceGroup, envObserverFeServiceGroup, envBackendServiceGroup, envBrokerServiceGroup);
        this.feConfigNode = Strings.nullToEmpty((String)System.getenv(ENV_AMBARI_FE_COMPONENTS_CONFIG));
        this.beConfigNode = Strings.nullToEmpty((String)System.getenv(ENV_AMBARI_BE_COMPONENTS_CONFIG));
        this.brokerConfigNode = Strings.nullToEmpty((String)System.getenv(ENV_AMBARI_BROKER_COMPONENTS_CONFIG));
        if (Strings.isNullOrEmpty((String)this.feConfigNode) || Strings.isNullOrEmpty((String)this.beConfigNode)) {
            LOG.error("failed to get fe config node: {} or be config node: {}. env var: {}, {}", (Object)this.feConfigNode, (Object)this.beConfigNode, (Object)ENV_AMBARI_FE_COMPONENTS_CONFIG, (Object)ENV_AMBARI_BE_COMPONENTS_CONFIG);
            System.exit(-1);
        }
        if (Strings.isNullOrEmpty((String)this.brokerConfigNode)) {
            LOG.warn("can not get broker config node from env var: {}", (Object)ENV_AMBARI_BROKER_COMPONENTS_CONFIG);
            this.hasBrokerService = false;
        }
        LOG.info("get fe, be and broker config node name: {}, {}, {}", (Object)this.feConfigNode, (Object)this.beConfigNode, (Object)this.brokerConfigNode);
        this.authInfo = System.getenv(ENV_AUTH_INFO);
        LOG.info("get ambari auth info: {}", (Object)this.authInfo);
        this.encodedAuthInfo = Base64.encodeBase64String((byte[])this.authInfo.getBytes());
        String ambariHost = System.getenv(ENV_AMBARI_HOST);
        String ambariPort = System.getenv(ENV_AMBARI_PORT);
        if (Strings.isNullOrEmpty((String)ambariHost) || Strings.isNullOrEmpty((String)ambariPort)) {
            LOG.error("failed to get ambari host {} or ambari port {}", (Object)ambariHost, (Object)ambariPort);
            System.exit(-1);
        }
        int port = -1;
        try {
            port = Integer.valueOf(ambariPort);
        }
        catch (NumberFormatException e) {
            LOG.error("invalid ambari port format: {}", (Object)ambariPort);
            System.exit(-1);
        }
        this.ambariUrl = String.format("%s:%d", ambariHost, port);
        LOG.info("get ambari url: {}", (Object)this.ambariUrl);
        this.clusterName = System.getenv(ENV_AMBARI_CLUSTER);
        if (Strings.isNullOrEmpty((String)this.clusterName)) {
            LOG.error("failed to get ambari cluster", (Object)this.clusterName);
            System.exit(-1);
        }
        this.serviceName = System.getenv(ENV_AMBARI_SERVICE_NAME);
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            LOG.error("failed to get ambari service name", (Object)this.serviceName);
            System.exit(-1);
        }
        this.blueprintUrl = String.format(URL_BLUEPRINT, this.ambariUrl, this.clusterName);
        LOG.info("get ambari blueprint url: {}", (Object)this.blueprintUrl);
        if (!this.init()) {
            System.exit(-1);
        }
    }

    @Override
    protected boolean init() {
        super.init();
        this.blueprintJson = Util.getResultForUrl(this.blueprintUrl, this.encodedAuthInfo, 2000, 2000);
        return this.blueprintJson != null;
    }

    @Override
    protected List<Pair<String, Integer>> getGroupHostPorts(String groupName) {
        int port = -1;
        if (groupName.equalsIgnoreCase(this.electableFeServiceGroup)) {
            port = this.getFeEditLogPort();
        } else if (groupName.equalsIgnoreCase(this.backendServiceGroup)) {
            port = this.getBeHeartbeatPort();
        } else {
            LOG.warn("unknown group name: {}", (Object)groupName);
            return null;
        }
        if (port == -1) {
            LOG.warn("failed to get port of component: {}", (Object)groupName);
            return null;
        }
        List<String> hostnames = this.getHostnamesFromComponentsJson(groupName);
        ArrayList hostPorts = Lists.newArrayListWithCapacity((int)hostnames.size());
        for (String hostname : hostnames) {
            Pair<String, Integer> hostPort = null;
            try {
                hostPort = SystemInfoService.validateHostAndPort(hostname + ":" + port);
            }
            catch (AnalysisException e) {
                LOG.warn("Invalid host port format: {}:{}", (Object)hostname, (Object)port, (Object)e);
                continue;
            }
            hostPorts.add(hostPort);
        }
        LOG.info("get {} hosts from ambari: {}", (Object)groupName, (Object)hostPorts);
        return hostPorts;
    }

    @Override
    protected Map<String, List<Pair<String, Integer>>> getBrokerGroupHostPorts() {
        int port = this.getBrokerIpcPort();
        if (port == -1) {
            LOG.warn("failed to get port of component: {}", (Object)this.brokerServiceGroup);
            return null;
        }
        String brokerName = this.getPropertyFromBlueprint(this.brokerConfigNode, KEY_BROKER_NAME);
        if (brokerName == null) {
            return null;
        }
        List<String> hostnames = this.getHostnamesFromComponentsJson(this.brokerServiceGroup);
        ArrayList hostPorts = Lists.newArrayListWithCapacity((int)hostnames.size());
        for (String hostname : hostnames) {
            Pair<String, Integer> hostPort = null;
            try {
                hostPort = SystemInfoService.validateHostAndPort(hostname + ":" + port);
            }
            catch (AnalysisException e) {
                LOG.warn("Invalid host port format: {}:{}", (Object)hostname, (Object)port, (Object)e);
                continue;
            }
            hostPorts.add(hostPort);
        }
        HashMap brokers = Maps.newHashMap();
        brokers.put(brokerName, hostPorts);
        LOG.info("get brokers from ambari: {}", (Object)brokers);
        return brokers;
    }

    private Integer getFeEditLogPort() {
        return this.getPort(this.feConfigNode, KEY_FE_EDIT_LOG_PORT);
    }

    private Integer getBeHeartbeatPort() {
        return this.getPort(this.beConfigNode, KEY_BE_HEARTBEAT_PORT);
    }

    private Integer getBrokerIpcPort() {
        return this.getPort(this.brokerConfigNode, KEY_BROKER_IPC_PORT);
    }

    private Integer getPort(String configNodeName, String portName) {
        String portStr = this.getPropertyFromBlueprint(configNodeName, portName);
        if (portStr == null) {
            return -1;
        }
        Integer port = -1;
        try {
            port = Integer.valueOf(portStr);
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid port format: {} of port {}", (Object)portStr, (Object)portName);
            return -1;
        }
        return port;
    }

    private List<String> getHostnamesFromComponentsJson(String componentName) {
        String urlStr = String.format(URL_COMPONENTS, this.ambariUrl, this.clusterName, this.serviceName, componentName);
        String componentsJson = Util.getResultForUrl(urlStr, this.encodedAuthInfo, 2000, 2000);
        if (componentsJson == null) {
            return null;
        }
        ArrayList hostnames = Lists.newArrayList();
        JSONObject componentsObj = (JSONObject)JSONValue.parse((String)componentsJson);
        JSONArray componentsArray = (JSONArray)componentsObj.get((Object)KEY_HOST_COMPONENTS);
        for (Object component : componentsArray) {
            JSONObject componentObj = (JSONObject)component;
            try {
                JSONObject roleObj = (JSONObject)componentObj.get((Object)KEY_HOST_ROLES);
                String hostname = (String)roleObj.get((Object)KEY_HOST_NAME);
                hostnames.add(hostname);
            }
            catch (Exception exception) {}
        }
        return hostnames;
    }

    private String getPropertyFromBlueprint(String configNodeName, String propName) {
        Preconditions.checkNotNull((Object)this.blueprintJson);
        String resProp = null;
        JSONObject root = (JSONObject)JSONValue.parse((String)this.blueprintJson);
        JSONArray confArray = (JSONArray)root.get((Object)"configurations");
        for (Object object : confArray) {
            JSONObject jobj = (JSONObject)object;
            try {
                JSONObject comNameObj = (JSONObject)jobj.get((Object)configNodeName);
                JSONObject propObj = (JSONObject)comNameObj.get((Object)"properties");
                resProp = (String)propObj.get((Object)propName);
            }
            catch (Exception exception) {}
        }
        if (resProp == null) {
            LOG.warn("failed to get component {} property {}", (Object)configNodeName, (Object)propName);
        }
        return resProp;
    }
}

