/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.deploy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeployManager
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(DeployManager.class);
    @Deprecated
    public static final String ENV_FE_EXIST_ENTPOINT = "FE_EXIST_ENTPOINT";
    public static final String ENV_FE_EXIST_ENDPOINT = "FE_EXIST_ENDPOINT";
    public static final String ENV_FE_INIT_NUMBER = "FE_INIT_NUMBER";
    protected Catalog catalog;
    protected String electableFeServiceGroup;
    protected String observerFeServiceGroup;
    protected String backendServiceGroup;
    protected String brokerServiceGroup;
    protected boolean hasObserverService = false;
    protected boolean hasBrokerService = false;
    protected Map<String, Integer> counterMap = Maps.newHashMap();
    protected static final Integer MAX_MISSING_TIME = 3;

    public DeployManager(Catalog catalog, long intervalMs) {
        super("deployManager", intervalMs);
        this.catalog = catalog;
    }

    protected void initEnvVariables(String envElectableFeServiceGroup, String envObserverFeServiceGroup, String envBackendServiceGroup, String envBrokerServiceGroup) {
        this.electableFeServiceGroup = Strings.nullToEmpty((String)System.getenv(envElectableFeServiceGroup));
        this.observerFeServiceGroup = Strings.nullToEmpty((String)System.getenv(envObserverFeServiceGroup));
        this.backendServiceGroup = Strings.nullToEmpty((String)System.getenv(envBackendServiceGroup));
        this.brokerServiceGroup = Strings.nullToEmpty((String)System.getenv(envBrokerServiceGroup));
        LOG.info("get deploy env: {}, {}, {}, {}", (Object)envElectableFeServiceGroup, (Object)envObserverFeServiceGroup, (Object)envBackendServiceGroup, (Object)envBrokerServiceGroup);
        if (Strings.isNullOrEmpty((String)this.electableFeServiceGroup) || Strings.isNullOrEmpty((String)this.backendServiceGroup)) {
            LOG.warn("failed to init service group name. electableFeServiceGroup: {}, backendServiceGroup: {}", (Object)this.electableFeServiceGroup, (Object)this.backendServiceGroup);
            System.exit(-1);
        }
        if (!Strings.isNullOrEmpty((String)this.observerFeServiceGroup)) {
            LOG.info("Observer service group is found");
            this.hasObserverService = true;
        }
        if (!Strings.isNullOrEmpty((String)this.brokerServiceGroup)) {
            LOG.info("Broker service group is found");
            this.hasBrokerService = true;
        }
        LOG.info("get electableFeServiceGroup: {}, observerFeServiceGroup: {}, backendServiceGroup: {} brokerServiceGroup: {}", (Object)this.electableFeServiceGroup, (Object)this.observerFeServiceGroup, (Object)this.backendServiceGroup, (Object)this.brokerServiceGroup);
    }

    protected boolean init() {
        return true;
    }

    protected List<Pair<String, Integer>> getElectableGroupHostPorts() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.electableFeServiceGroup) ? 1 : 0) != 0);
        return this.getGroupHostPorts(this.electableFeServiceGroup);
    }

    protected List<Pair<String, Integer>> getObserverGroupHostPorts() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.observerFeServiceGroup) ? 1 : 0) != 0);
        return this.getGroupHostPorts(this.observerFeServiceGroup);
    }

    protected List<Pair<String, Integer>> getBackendGroupHostPorts() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.backendServiceGroup) ? 1 : 0) != 0);
        return this.getGroupHostPorts(this.backendServiceGroup);
    }

    protected List<Pair<String, Integer>> getGroupHostPorts(String groupName) {
        throw new NotImplementedException();
    }

    protected Map<String, List<Pair<String, Integer>>> getBrokerGroupHostPorts() {
        throw new NotImplementedException();
    }

    public List<Pair<String, Integer>> getHelperNodes() {
        String existFeHosts = System.getenv(ENV_FE_EXIST_ENTPOINT);
        if (Strings.isNullOrEmpty((String)existFeHosts)) {
            existFeHosts = System.getenv(ENV_FE_EXIST_ENDPOINT);
        }
        if (!Strings.isNullOrEmpty((String)existFeHosts)) {
            String[] splittedHosts;
            ArrayList helperNodes = Lists.newArrayList();
            for (String host : splittedHosts = existFeHosts.split(",")) {
                String[] splittedHostPort = host.split(":");
                if (splittedHostPort.length != 2) {
                    LOG.error("Invalid exist fe hosts: {}. will exit", (Object)existFeHosts);
                    System.exit(-1);
                }
                Integer port = -1;
                try {
                    port = Integer.valueOf(splittedHostPort[1]);
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid exist fe hosts: {}. will exit", (Object)existFeHosts);
                    System.exit(-1);
                }
                helperNodes.add(Pair.create(splittedHostPort[0], port));
            }
            return helperNodes;
        }
        String numOfFeStr = System.getenv(ENV_FE_INIT_NUMBER);
        if (Strings.isNullOrEmpty((String)numOfFeStr)) {
            LOG.error("No init FE num is specified. will exit");
            System.exit(-1);
        }
        Integer numOfFe = -1;
        try {
            numOfFe = Integer.valueOf(numOfFeStr);
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid format of num of fe: {}. will exit", (Object)numOfFeStr);
            System.exit(-1);
        }
        LOG.info("get init num of fe from env: {}", (Object)numOfFe);
        boolean ok = true;
        List<Pair<String, Integer>> feHostPorts = null;
        while (true) {
            try {
                feHostPorts = this.getElectableGroupHostPorts();
                if (feHostPorts == null) {
                    ok = false;
                } else if (feHostPorts.size() != numOfFe.intValue()) {
                    LOG.error("num of fe get from remote [{}] does not equal to the expected num: {}", feHostPorts, (Object)numOfFe);
                    ok = false;
                } else {
                    ok = true;
                }
            }
            catch (Exception e) {
                LOG.error("failed to get electable fe hosts from remote.", (Throwable)e);
                ok = false;
            }
            if (ok) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("get InterruptedException when sleep", (Throwable)e);
                System.exit(-1);
                break;
            }
        }
        LOG.info("get electable fe host from remote: {}", feHostPorts);
        Collections.sort(feHostPorts, new PairComparator());
        LOG.info("sorted fe host list: {}", feHostPorts);
        return feHostPorts.subList(0, 1);
    }

    @Override
    protected void runAfterCatalogReady() {
        Map<String, List<Pair<String, Integer>>> remoteBrokerHosts;
        List<Pair<String, Integer>> remoteObserverFeHosts;
        if (Config.enable_deploy_manager.equals("disable")) {
            LOG.warn("Config enable_deploy_manager is disable. Exit deploy manager");
            this.exit();
            return;
        }
        if (!this.init()) {
            return;
        }
        List<Pair<String, Integer>> remoteElectableFeHosts = this.getElectableGroupHostPorts();
        if (remoteElectableFeHosts == null) {
            return;
        }
        LOG.debug("get electable fe hosts {} from electable fe service group: {}", remoteElectableFeHosts, (Object)this.electableFeServiceGroup);
        if (remoteElectableFeHosts.isEmpty()) {
            LOG.error("electable fe service group {} is empty, which should not happen", (Object)this.electableFeServiceGroup);
            return;
        }
        Pair<String, Integer> selfHost = this.getHostFromPairList(remoteElectableFeHosts, this.catalog.getMasterIp(), Config.edit_log_port);
        if (selfHost == null) {
            LOG.warn("self host {} is not in electable fe service group {}. Exit now.", selfHost, (Object)this.electableFeServiceGroup);
            System.exit(-1);
        }
        List<Frontend> localElectableFeAddrs = this.catalog.getFrontends(FrontendNodeType.FOLLOWER);
        List<Pair<String, Integer>> localElectableFeHosts = this.convertToHostPortPair(localElectableFeAddrs);
        LOG.debug("get local electable hosts: {}", localElectableFeHosts);
        if (this.inspectNodeChange(remoteElectableFeHosts, localElectableFeHosts, NodeType.ELECTABLE)) {
            return;
        }
        List<Pair<String, Integer>> remoteBackendHosts = this.getBackendGroupHostPorts();
        if (remoteBackendHosts != null) {
            LOG.debug("get remote backend hosts: {}", remoteBackendHosts);
            List<Backend> localBackends = Catalog.getCurrentSystemInfo().getClusterBackends("default_cluster");
            ArrayList localBackendHosts = Lists.newArrayList();
            for (Backend backend : localBackends) {
                localBackendHosts.add(Pair.create(backend.getHost(), backend.getHeartbeatPort()));
            }
            LOG.debug("get local backend addrs: {}", (Object)localBackendHosts);
            if (this.inspectNodeChange(remoteBackendHosts, localBackendHosts, NodeType.BACKEND)) {
                return;
            }
        }
        if (this.hasObserverService && (remoteObserverFeHosts = this.getObserverGroupHostPorts()) != null) {
            LOG.debug("get remote observer fe hosts: {}", remoteObserverFeHosts);
            List<Frontend> localObserverFeAddrs = this.catalog.getFrontends(FrontendNodeType.OBSERVER);
            List<Pair<String, Integer>> localObserverFeHosts = this.convertToHostPortPair(localObserverFeAddrs);
            LOG.debug("get local observer fe hosts: {}", localObserverFeHosts);
            if (this.inspectNodeChange(remoteObserverFeHosts, localObserverFeHosts, NodeType.OBSERVER)) {
                return;
            }
        }
        if (this.hasBrokerService && (remoteBrokerHosts = this.getBrokerGroupHostPorts()) != null) {
            Map<String, List<FsBroker>> localBrokers = this.catalog.getBrokerMgr().getBrokerListMap();
            for (Map.Entry<String, List<FsBroker>> entry : localBrokers.entrySet()) {
                String brokerName = entry.getKey();
                if (remoteBrokerHosts.containsKey(brokerName)) {
                    ArrayList list;
                    List<FsBroker> localList = entry.getValue();
                    List<Pair<String, Integer>> remoteList = remoteBrokerHosts.get(brokerName);
                    for (FsBroker fsBroker : localList) {
                        Pair<String, Integer> foundHost = this.getHostFromPairList(remoteList, fsBroker.ip, fsBroker.port);
                        if (foundHost != null) continue;
                        list = Lists.newArrayList();
                        list.add(Pair.create(fsBroker.ip, fsBroker.port));
                        try {
                            this.catalog.getBrokerMgr().dropBrokers(brokerName, list);
                            LOG.info("drop broker {}:{} with name: {}", (Object)fsBroker.ip, (Object)fsBroker.port, (Object)brokerName);
                        }
                        catch (DdlException e) {
                            LOG.warn("failed to drop broker {}:{} with name: {}", (Object)fsBroker.ip, (Object)fsBroker.port, (Object)brokerName, (Object)e);
                        }
                    }
                    for (Pair pair : remoteList) {
                        FsBroker foundAddr = this.getHostFromBrokerAddrs(localList, (String)pair.first, (Integer)pair.second);
                        if (foundAddr != null) continue;
                        list = Lists.newArrayList();
                        list.add(Pair.create((String)pair.first, (Integer)pair.second));
                        try {
                            this.catalog.getBrokerMgr().addBrokers(brokerName, list);
                            LOG.info("add broker {}:{} with name {}", pair.first, pair.second, (Object)brokerName);
                        }
                        catch (DdlException e) {
                            LOG.warn("failed to add broker {}:{} with name {}", pair.first, pair.second, (Object)brokerName);
                        }
                    }
                    continue;
                }
                try {
                    this.catalog.getBrokerMgr().dropAllBroker(brokerName);
                    LOG.info("drop all brokers with name: {}", (Object)brokerName);
                }
                catch (DdlException e) {
                    LOG.warn("failed to drop all brokers with name: {}", (Object)brokerName, (Object)e);
                }
            }
            for (Map.Entry<String, List<Object>> entry : remoteBrokerHosts.entrySet()) {
                String remoteBrokerName = entry.getKey();
                if (localBrokers.containsKey(remoteBrokerName)) continue;
                try {
                    this.catalog.getBrokerMgr().addBrokers(remoteBrokerName, (Collection<Pair<String, Integer>>)entry.getValue());
                    LOG.info("add brokers {} with name {}", entry.getValue(), (Object)remoteBrokerName);
                }
                catch (DdlException e) {
                    LOG.info("failed to add brokers {} with name {}", entry.getValue(), (Object)remoteBrokerName, (Object)e);
                }
            }
        }
    }

    private FsBroker getHostFromBrokerAddrs(List<FsBroker> addrList, String ip, Integer port) {
        for (FsBroker brokerAddress : addrList) {
            if (!brokerAddress.ip.equals(ip) || brokerAddress.port != port) continue;
            return brokerAddress;
        }
        return null;
    }

    private boolean inspectNodeChange(List<Pair<String, Integer>> remoteHosts, List<Pair<String, Integer>> localHosts, NodeType nodeType) {
        Pair<String, Integer> foundHost;
        for (Pair<String, Integer> localHost : localHosts) {
            String localIp = (String)localHost.first;
            Integer localPort = (Integer)localHost.second;
            foundHost = this.getHostFromPairList(remoteHosts, localIp, localPort);
            if (foundHost != null) continue;
            if (this.isSelf(localIp, localPort)) {
                LOG.error("self host {}:{} does not exist in remote hosts. Showdown.");
                System.exit(-1);
            }
            if (!this.counterMap.containsKey(localHost.toString())) {
                LOG.warn("downtime of {} node: {} detected times: 1", (Object)nodeType.name(), localHost);
                this.counterMap.put(localHost.toString(), 1);
                return false;
            }
            int times = this.counterMap.get(localHost.toString());
            if (times < MAX_MISSING_TIME) {
                LOG.warn("downtime of {} node: {} detected times: {}", (Object)nodeType.name(), localHost, (Object)(times + 1));
                this.counterMap.put(localHost.toString(), times + 1);
                return false;
            }
            LOG.warn("downtime of {} node: {} detected times: {}. drop it", (Object)nodeType.name(), localHost, (Object)(times + 1));
            this.counterMap.remove(localHost.toString());
            LOG.info("For now, Deploy Manager dose not handle shrinking operations");
        }
        for (Pair<String, Integer> remoteHost : remoteHosts) {
            String remoteIp = (String)remoteHost.first;
            Integer remotePort = (Integer)remoteHost.second;
            foundHost = this.getHostFromPairList(localHosts, remoteIp, remotePort);
            if (foundHost != null) continue;
            try {
                switch (nodeType) {
                    case ELECTABLE: {
                        this.catalog.addFrontend(FrontendNodeType.FOLLOWER, remoteIp, remotePort);
                        break;
                    }
                    case OBSERVER: {
                        this.catalog.addFrontend(FrontendNodeType.OBSERVER, remoteIp, remotePort);
                        break;
                    }
                    case BACKEND: {
                        ArrayList newBackends = Lists.newArrayList();
                        newBackends.add(Pair.create(remoteIp, remotePort));
                        Catalog.getCurrentSystemInfo().addBackends(newBackends, false);
                        break;
                    }
                }
            }
            catch (UserException e) {
                LOG.error("Failed to add {} node: {}:{}", (Object)nodeType, (Object)remoteIp, (Object)remotePort, (Object)e);
                return true;
            }
            LOG.info("Finished to add {} node: {}:{}", (Object)nodeType, (Object)remoteIp, (Object)remotePort);
            return true;
        }
        return false;
    }

    private Pair<String, Integer> getHostFromPairList(List<Pair<String, Integer>> pairList, String ip, Integer port) {
        for (Pair<String, Integer> pair : pairList) {
            if (!ip.equals(pair.first) || !port.equals(pair.second)) continue;
            return pair;
        }
        return null;
    }

    private List<Pair<String, Integer>> convertToHostPortPair(List<Frontend> frontends) {
        ArrayList hostPortPair = Lists.newArrayList();
        for (Frontend fe : frontends) {
            hostPortPair.add(Pair.create(fe.getHost(), fe.getEditLogPort()));
        }
        return hostPortPair;
    }

    private boolean isSelf(String ip, Integer port) {
        return this.catalog.getMasterIp().equals(ip) && Config.edit_log_port == port;
    }

    private static class PairComparator<T extends Pair<String, Integer>>
    implements Comparator<T> {
        private PairComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            int res = ((String)((Pair)o1).first).compareTo((String)((Pair)o2).first);
            if (res == 0) {
                return ((Integer)((Pair)o1).second).compareTo((Integer)((Pair)o2).second);
            }
            return res;
        }
    }

    public static enum NodeType {
        ELECTABLE,
        OBSERVER,
        BACKEND,
        BROKER;

    }
}

