/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.consistency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MetaObject;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.Config;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.consistency.CheckConsistencyJob;
import org.apache.doris.persist.ConsistencyCheckInfo;
import org.apache.doris.task.CheckConsistencyTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsistencyChecker
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(ConsistencyChecker.class);
    private static final int MAX_JOB_NUM = 100;
    private static final Comparator<MetaObject> COMPARATOR = (first, second) -> Long.signum(first.getLastCheckTime() - second.getLastCheckTime());
    private Map<Long, CheckConsistencyJob> jobs = Maps.newHashMap();
    private ReentrantReadWriteLock jobsLock = new ReentrantReadWriteLock();
    private int startTime;
    private int endTime;

    public ConsistencyChecker() {
        super("consistency checker");
        if (!this.initWorkTime()) {
            LOG.error("failed to init time in ConsistencyChecker. exit");
            System.exit(-1);
        }
    }

    private boolean initWorkTime() {
        Date startDate = TimeUtils.getTimeAsDate(Config.consistency_check_start_time);
        Date endDate = TimeUtils.getTimeAsDate(Config.consistency_check_end_time);
        if (startDate == null || endDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.startTime = calendar.get(11);
        calendar.setTime(endDate);
        this.endTime = calendar.get(11);
        LOG.info("consistency checker will work from {}:00 to {}:00", (Object)this.startTime, (Object)this.endTime);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runAfterCatalogReady() {
        if (this.itsTime() && this.getJobNum() == 0) {
            List<Long> chosenTabletIds = this.chooseTablets();
            for (Long tabletId : chosenTabletIds) {
                CheckConsistencyJob job = new CheckConsistencyJob(tabletId);
                this.addJob(job);
            }
        }
        this.jobsLock.writeLock().lock();
        try {
            Iterator<Map.Entry<Long, CheckConsistencyJob>> iterator = this.jobs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, CheckConsistencyJob> entry = iterator.next();
                CheckConsistencyJob oneJob = entry.getValue();
                CheckConsistencyJob.JobState state = oneJob.getState();
                switch (state) {
                    case PENDING: {
                        if (oneJob.sendTasks()) break;
                        this.clearJob(oneJob);
                        iterator.remove();
                        break;
                    }
                    case RUNNING: {
                        int res = oneJob.tryFinishJob();
                        if (res != -1 && res != 1) break;
                        this.clearJob(oneJob);
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        finally {
            this.jobsLock.writeLock().unlock();
        }
    }

    private boolean itsTime() {
        if (this.startTime == this.endTime) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int currentTime = calendar.get(11);
        boolean isTime = false;
        isTime = this.startTime < this.endTime ? currentTime >= this.startTime && currentTime <= this.endTime : currentTime >= this.startTime || currentTime <= this.endTime;
        if (!isTime) {
            LOG.debug("current time is {}:00, waiting to {}:00 to {}:00", (Object)currentTime, (Object)this.startTime, (Object)this.endTime);
        }
        return isTime;
    }

    private void clearJob(CheckConsistencyJob job) {
        job.clear();
        LOG.debug("tablet[{}] consistency checking job is cleared", (Object)job.getTabletId());
    }

    private boolean addJob(CheckConsistencyJob job) {
        this.jobsLock.writeLock().lock();
        try {
            if (this.jobs.containsKey(job.getTabletId())) {
                boolean bl = false;
                return bl;
            }
            LOG.info("add tablet[{}] to check consistency", (Object)job.getTabletId());
            this.jobs.put(job.getTabletId(), job);
            boolean bl = true;
            return bl;
        }
        finally {
            this.jobsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckConsistencyJob getJob(long tabletId) {
        this.jobsLock.readLock().lock();
        try {
            CheckConsistencyJob checkConsistencyJob = this.jobs.get(tabletId);
            return checkConsistencyJob;
        }
        finally {
            this.jobsLock.readLock().unlock();
        }
    }

    private int getJobNum() {
        this.jobsLock.readLock().lock();
        try {
            int n = this.jobs.size();
            return n;
        }
        finally {
            this.jobsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> chooseTablets() {
        ArrayList chosenTablets;
        block21: {
            Catalog catalog = Catalog.getCurrentCatalog();
            MetaObject chosenOne = null;
            chosenTablets = Lists.newArrayList();
            List<Long> dbIds = catalog.getDbIds();
            if (dbIds.isEmpty()) {
                return chosenTablets;
            }
            PriorityQueue<MetaObject> dbQueue = new PriorityQueue<MetaObject>(Math.max(dbIds.size(), 1), COMPARATOR);
            for (Long dbId : dbIds) {
                Database db;
                if (dbId == 0L || (db = catalog.getDbNullable(dbId)) == null) continue;
                dbQueue.add(db);
            }
            this.jobsLock.readLock().lock();
            block9: while (true) {
                chosenOne = (MetaObject)dbQueue.poll();
                if (chosenOne != null) {
                    Database db = (Database)chosenOne;
                    List<Table> tables = db.getTables();
                    PriorityQueue<MetaObject> tableQueue = new PriorityQueue<MetaObject>(Math.max(tables.size(), 1), COMPARATOR);
                    for (Table table : tables) {
                        if (table.getType() != Table.TableType.OLAP) continue;
                        tableQueue.add(table);
                    }
                    block11: while (true) {
                        if ((chosenOne = (MetaObject)tableQueue.poll()) == null) continue block9;
                        OlapTable table = (OlapTable)chosenOne;
                        table.readLock();
                        try {
                            PriorityQueue<MetaObject> partitionQueue = new PriorityQueue<MetaObject>(Math.max(table.getAllPartitions().size(), 1), COMPARATOR);
                            for (Partition partition : table.getPartitions()) {
                                if (table.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum() == 1) {
                                    LOG.debug("partition[{}]'s replication num is 1. ignore", (Object)partition.getId());
                                    continue;
                                }
                                if (partition.getVisibleVersion() == 1L) {
                                    LOG.debug("partition[{}]'s version is {}. ignore", (Object)partition.getId(), (Object)1L);
                                    continue;
                                }
                                partitionQueue.add(partition);
                            }
                            while (true) {
                                if ((chosenOne = (MetaObject)partitionQueue.poll()) == null) continue block11;
                                Partition partition = (Partition)chosenOne;
                                List<MaterializedIndex> visibleIndexes = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE);
                                PriorityQueue<MetaObject> indexQueue = new PriorityQueue<MetaObject>(Math.max(visibleIndexes.size(), 1), COMPARATOR);
                                indexQueue.addAll(visibleIndexes);
                                while ((chosenOne = (MetaObject)indexQueue.poll()) != null) {
                                    MaterializedIndex index = (MaterializedIndex)chosenOne;
                                    PriorityQueue<MetaObject> tabletQueue = new PriorityQueue<MetaObject>(Math.max(index.getTablets().size(), 1), COMPARATOR);
                                    tabletQueue.addAll(index.getTablets());
                                    while ((chosenOne = (MetaObject)tabletQueue.poll()) != null) {
                                        Tablet tablet = (Tablet)chosenOne;
                                        long chosenTabletId = tablet.getId();
                                        if (this.jobs.containsKey(chosenTabletId)) continue;
                                        if (partition.getVisibleVersion() == tablet.getCheckedVersion()) {
                                            if (!tablet.isConsistent()) continue;
                                            LOG.debug("tablet[{}]'s version[{}] has been checked. ignore", (Object)chosenTabletId, (Object)tablet.getCheckedVersion());
                                            continue;
                                        }
                                        LOG.info("chose tablet[{}-{}-{}-{}-{}] to check consistency", (Object)db.getId(), (Object)table.getId(), (Object)partition.getId(), (Object)index.getId(), (Object)chosenTabletId);
                                        chosenTablets.add(chosenTabletId);
                                    }
                                }
                                if (chosenTablets.size() < 100) continue;
                                ArrayList arrayList = chosenTablets;
                                return arrayList;
                            }
                        }
                        finally {
                            table.readUnlock();
                            continue;
                        }
                        break;
                    }
                }
                break block21;
                break;
            }
            finally {
                this.jobsLock.readLock().unlock();
            }
        }
        return chosenTablets;
    }

    public void handleFinishedConsistencyCheck(CheckConsistencyTask task, long checksum) {
        long tabletId = task.getTabletId();
        long backendId = task.getBackendId();
        CheckConsistencyJob job = this.getJob(tabletId);
        if (job == null) {
            LOG.warn("cannot find {} job[{}]", (Object)task.getTaskType().name(), (Object)tabletId);
            return;
        }
        job.handleFinishedReplica(backendId, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayFinishConsistencyCheck(ConsistencyCheckInfo info, Catalog catalog) throws MetaNotFoundException {
        Database db = catalog.getDbOrMetaException(info.getDbId());
        OlapTable table = (OlapTable)db.getTableOrMetaException(info.getTableId());
        table.writeLock();
        try {
            Partition partition = table.getPartition(info.getPartitionId());
            MaterializedIndex index = partition.getIndex(info.getIndexId());
            Tablet tablet = index.getTablet(info.getTabletId());
            long lastCheckTime = info.getLastCheckTime();
            db.setLastCheckTime(lastCheckTime);
            table.setLastCheckTime(lastCheckTime);
            partition.setLastCheckTime(lastCheckTime);
            index.setLastCheckTime(lastCheckTime);
            tablet.setLastCheckTime(lastCheckTime);
            tablet.setCheckedVersion(info.getCheckedVersion());
            tablet.setIsConsistent(info.isConsistent());
        }
        finally {
            table.writeUnlock();
        }
    }

    public void addTabletsToCheck(List<Long> tabletIds) {
        for (Long tabletId : tabletIds) {
            CheckConsistencyJob job = new CheckConsistencyJob(tabletId);
            this.addJob(job);
        }
    }
}

