/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.CommandResult;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final Logger LOG = LogManager.getLogger(Util.class);
    private static final Map<PrimitiveType, String> TYPE_STRING_MAP = new HashMap<PrimitiveType, String>();
    private static final long DEFAULT_EXEC_CMD_TIMEOUT_MS = 600000L;
    private static final String[] ORDINAL_SUFFIX = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    private static final List<String> REGEX_ESCAPES = Lists.newArrayList((Object[])new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"});

    public static CommandResult executeCommand(String cmd, String[] envp) {
        return Util.executeCommand(cmd, envp, 600000L);
    }

    public static CommandResult executeCommand(String cmd, String[] envp, long timeoutMs) {
        CommandResult result = new CommandResult();
        List<String> cmdList = Util.shellSplit(cmd);
        String[] cmds = cmdList.toArray(new String[0]);
        try {
            Process p = Runtime.getRuntime().exec(cmds, envp);
            CmdWorker cmdWorker = new CmdWorker(p);
            cmdWorker.start();
            Integer exitValue = -1;
            try {
                cmdWorker.join(timeoutMs);
                exitValue = cmdWorker.getExitValue();
                if (exitValue == null) {
                    LOG.warn("exec command [{}] timed out.", (Object)cmd);
                    exitValue = -1;
                }
            }
            catch (InterruptedException ex) {
                cmdWorker.interrupt();
                Thread.currentThread().interrupt();
                throw ex;
            }
            finally {
                p.destroy();
            }
            result.setReturnCode(exitValue);
            result.setStdout(cmdWorker.getStdOut());
            result.setStderr(cmdWorker.getErrOut());
        }
        catch (IOException e) {
            LOG.warn("execute command error", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn("execute command error", (Throwable)e);
        }
        return result;
    }

    public static List<String> shellSplit(CharSequence string) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean escaping = false;
        char quoteChar = ' ';
        boolean quoting = false;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaping) {
                current.append(c);
                escaping = false;
                continue;
            }
            if (!(c != '\\' || quoting && quoteChar == '\'')) {
                escaping = true;
                continue;
            }
            if (quoting && c == quoteChar) {
                quoting = false;
                continue;
            }
            if (!(quoting || c != '\'' && c != '\"')) {
                quoting = true;
                quoteChar = c;
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                if (current.length() <= 0) continue;
                tokens.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            tokens.add(current.toString());
        }
        return tokens;
    }

    public static String getSchemaSignatureString(List<Column> columns) {
        StringBuilder sb = new StringBuilder();
        for (Column column : columns) {
            sb.append(column.getSignatureString(TYPE_STRING_MAP));
        }
        return sb.toString();
    }

    public static int generateSchemaHash() {
        return Math.abs(new Random().nextInt());
    }

    public static <T> List<T> sample(List<T> population, int kNum) {
        if (population.isEmpty() || population.size() < kNum) {
            return null;
        }
        Collections.shuffle(population);
        return population.subList(0, kNum);
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (!directory.exists()) {
            return true;
        }
        if (directory.isDirectory() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Util.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static String dumpThread(Thread t, int lineNum) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = t.getStackTrace();
        sb.append("dump thread: ").append(t.getName()).append(", id: ").append(t.getId()).append("\n");
        int count = lineNum;
        for (StackTraceElement element : elements) {
            if (count == 0) break;
            sb.append("    ").append(element.toString()).append("\n");
            --count;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResultForUrl(String urlStr, String encodedAuthInfo, int connectTimeoutMs, int readTimeoutMs) {
        StringBuilder sb = new StringBuilder();
        InputStream stream = null;
        try {
            String line;
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            if (encodedAuthInfo != null) {
                conn.setRequestProperty("Authorization", "Basic " + encodedAuthInfo);
            }
            conn.setConnectTimeout(connectTimeoutMs);
            conn.setReadTimeout(readTimeoutMs);
            stream = (InputStream)conn.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            LOG.warn("failed to get result from url: {}. {}", (Object)urlStr, (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.warn("failed to close stream when get result from url: {}", (Object)urlStr, (Object)e);
                    return null;
                }
            }
        }
        LOG.debug("get result from url {}: {}", (Object)urlStr, (Object)sb.toString());
        return sb.toString();
    }

    public static long getLongPropertyOrDefault(String valStr, long defaultVal, Predicate<Long> pred, String hintMsg) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)valStr)) {
            return defaultVal;
        }
        long result = defaultVal;
        try {
            result = Long.valueOf(valStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException(hintMsg);
        }
        if (pred == null) {
            return result;
        }
        if (!pred.test(result)) {
            throw new AnalysisException(hintMsg);
        }
        return result;
    }

    public static float getFloatPropertyOrDefault(String valStr, float defaultVal, Predicate<Float> pred, String hintMsg) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)valStr)) {
            return defaultVal;
        }
        float result = defaultVal;
        try {
            result = Float.valueOf(valStr).floatValue();
        }
        catch (NumberFormatException e) {
            throw new AnalysisException(hintMsg);
        }
        if (pred == null) {
            return result;
        }
        if (!pred.test(Float.valueOf(result))) {
            throw new AnalysisException(hintMsg);
        }
        return result;
    }

    public static boolean getBooleanPropertyOrDefault(String valStr, boolean defaultVal, String hintMsg) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)valStr)) {
            return defaultVal;
        }
        try {
            return Boolean.valueOf(valStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException(hintMsg);
        }
    }

    public static void stdoutWithTime(String msg) {
        System.out.println("[" + TimeUtils.longToTimeString(System.currentTimeMillis()) + "] " + msg);
    }

    public static void encodeVarint64(long source, DataOutput out) throws IOException {
        assert (source >= 0L);
        int B = 128;
        while (source > (long)B) {
            out.write((int)(source & (long)(B - 1) | (long)B));
            source >>= 7;
        }
        out.write((int)(source & (long)(B - 1)));
    }

    public static long decodeVarint64(DataInput in) throws IOException {
        long result = 0L;
        int shift = 0;
        int B = 128;
        while (true) {
            int oneByte;
            boolean isEnd = ((oneByte = in.readUnsignedByte()) & B) == 0;
            result |= (long)(oneByte & B - 1) << shift * 7;
            if (isEnd) break;
            ++shift;
        }
        return result;
    }

    public static String ordinal(int i) {
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + ORDINAL_SUFFIX[i % 10];
    }

    public static InputStream getInputStreamFromUrl(String urlStr, String encodedAuthInfo, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        URL url = new URL(urlStr);
        URLConnection conn = url.openConnection();
        if (encodedAuthInfo != null) {
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthInfo);
        }
        conn.setConnectTimeout(connectTimeoutMs);
        conn.setReadTimeout(readTimeoutMs);
        return conn.getInputStream();
    }

    public static boolean showHiddenColumns() {
        return ConnectContext.get() != null && ConnectContext.get().getSessionVariable().showHiddenColumns();
    }

    public static String escapeSingleRegex(String s) {
        Preconditions.checkArgument((s.length() == 1 ? 1 : 0) != 0);
        if (REGEX_ESCAPES.contains(s)) {
            return "\\" + s;
        }
        return s;
    }

    static {
        TYPE_STRING_MAP.put(PrimitiveType.TINYINT, "tinyint(4)");
        TYPE_STRING_MAP.put(PrimitiveType.SMALLINT, "smallint(6)");
        TYPE_STRING_MAP.put(PrimitiveType.INT, "int(11)");
        TYPE_STRING_MAP.put(PrimitiveType.BIGINT, "bigint(20)");
        TYPE_STRING_MAP.put(PrimitiveType.LARGEINT, "largeint(40)");
        TYPE_STRING_MAP.put(PrimitiveType.FLOAT, "float");
        TYPE_STRING_MAP.put(PrimitiveType.DOUBLE, "double");
        TYPE_STRING_MAP.put(PrimitiveType.DATE, "date");
        TYPE_STRING_MAP.put(PrimitiveType.DATETIME, "datetime");
        TYPE_STRING_MAP.put(PrimitiveType.CHAR, "char(%d)");
        TYPE_STRING_MAP.put(PrimitiveType.VARCHAR, "varchar(%d)");
        TYPE_STRING_MAP.put(PrimitiveType.STRING, "string");
        TYPE_STRING_MAP.put(PrimitiveType.DECIMALV2, "decimal(%d,%d)");
        TYPE_STRING_MAP.put(PrimitiveType.HLL, "varchar(%d)");
        TYPE_STRING_MAP.put(PrimitiveType.BOOLEAN, "bool");
        TYPE_STRING_MAP.put(PrimitiveType.BITMAP, "bitmap");
        TYPE_STRING_MAP.put(PrimitiveType.ARRAY, "Array<%s>");
        TYPE_STRING_MAP.put(PrimitiveType.NULL_TYPE, "null");
    }

    private static class CmdWorker
    extends Thread {
        private final Process process;
        private Integer exitValue;
        private StringBuffer outBuffer;
        private StringBuffer errBuffer;

        public CmdWorker(Process process) {
            this.process = process;
            this.outBuffer = new StringBuffer();
            this.errBuffer = new StringBuffer();
        }

        public Integer getExitValue() {
            return this.exitValue;
        }

        public String getStdOut() {
            return this.outBuffer.toString();
        }

        public String getErrOut() {
            return this.errBuffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader outReader = null;
            BufferedReader errReader = null;
            String line = null;
            try {
                outReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                while ((line = outReader.readLine()) != null) {
                    this.outBuffer.append(line + '\n');
                }
                errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((line = errReader.readLine()) != null) {
                    this.errBuffer.append(line + '\n');
                }
                this.exitValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("get exception", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("get exception", (Throwable)e);
            }
            finally {
                try {
                    if (outReader != null) {
                        outReader.close();
                    }
                    if (errReader != null) {
                        errReader.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("close buffered reader error", (Throwable)e);
                }
            }
        }
    }
}

