/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.AnalysisException;
import org.apache.parquet.Strings;

public class URI {
    private static final String SCHEME_DELIM = "://";
    private static final String AUTH_DELIM = "@";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private static final String PASS_DELIM = ":";
    private static final String PORT_DELIM = ":";
    private static final String QUERY_ITEM_DELIM = "&";
    private static final String QUERY_KV_DELIM = "=";
    private final String location;
    private String scheme;
    private String authority;
    private String host;
    private int port = -1;
    private String userInfo;
    private String userName;
    private String passWord;
    private String path = "";
    private String query;
    private String fragment;
    private TreeMap<String, String> queryMap;

    private URI(String location) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)location)) {
            throw new AnalysisException("location can not be null");
        }
        this.location = location.trim();
        this.parse();
    }

    public static URI create(String location) throws AnalysisException {
        return new URI(location);
    }

    public String getLocation() {
        return this.location;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public TreeMap<String, String> getQueryMap() {
        return this.queryMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parse() throws AnalysisException {
        String[] querySplit;
        String hostPortPath;
        String hierarchical;
        String[] schemeSplit = this.location.split(SCHEME_DELIM);
        if (schemeSplit.length == 1) {
            hierarchical = schemeSplit[0];
        } else {
            if (schemeSplit.length != 2) throw new AnalysisException("Invalid uri: " + this.location);
            this.scheme = schemeSplit[0];
            hierarchical = schemeSplit[1];
        }
        String[] authoritySplit = hierarchical.split(PATH_DELIM, 2);
        if (authoritySplit.length == 1) {
            if (!StringUtils.isBlank((String)this.scheme)) {
                this.authority = authoritySplit[0];
                this.parseAuthority(this.authority);
                return;
            }
            hostPortPath = authoritySplit[0];
        } else {
            if (authoritySplit.length != 2) throw new AnalysisException("Invalid uri: " + this.location);
            this.authority = authoritySplit[0];
            this.parseAuthority(this.authority);
            hostPortPath = authoritySplit[1];
        }
        String[] fragSplit = hostPortPath.split(FRAGMENT_DELIM);
        if (fragSplit.length == 2) {
            this.fragment = fragSplit[1];
        }
        if ((querySplit = fragSplit[0].split(QUERY_DELIM)).length == 1) {
            this.path = StringUtils.isBlank((String)this.host) ? querySplit[0] : PATH_DELIM + querySplit[0];
            return;
        }
        if (querySplit.length != 2) throw new AnalysisException("Invalid path: " + this.location);
        this.path = StringUtils.isBlank((String)this.host) ? querySplit[0] : PATH_DELIM + querySplit[0];
        this.query = querySplit[1];
        this.parseQuery();
    }

    private void parseQuery() {
        if (StringUtils.isBlank((String)this.query)) {
            return;
        }
        String[] split = this.query.split(QUERY_ITEM_DELIM);
        this.queryMap = new TreeMap();
        for (String item : split) {
            String[] itemSplit = item.split(QUERY_KV_DELIM);
            if (itemSplit.length != 2) continue;
            this.queryMap.put(itemSplit[0], itemSplit[1]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAuthority(String str) throws AnalysisException {
        String hostPort;
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        String[] authSplit = str.split(AUTH_DELIM);
        if (authSplit.length == 1) {
            hostPort = authSplit[0];
        } else {
            if (authSplit.length != 2) throw new AnalysisException("Invalid authority: " + str);
            this.userInfo = authSplit[0];
            hostPort = authSplit[1];
            String[] userSplit = this.userInfo.split(":");
            if (userSplit.length == 1) {
                this.userName = this.userInfo;
            } else {
                if (userSplit.length != 2) throw new AnalysisException("Invalid userinfo: " + this.userInfo);
                this.userName = userSplit[0];
                this.passWord = userSplit[1];
            }
        }
        String[] hostSplit = hostPort.split(":");
        if (hostSplit.length == 1) {
            this.host = hostSplit[0];
            return;
        } else {
            if (hostSplit.length != 2) throw new AnalysisException("Invalid host port: " + hostPort);
            this.host = hostSplit[0];
            this.port = Integer.parseInt(hostSplit[1]);
        }
    }
}

