/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SymmetricEncryption {
    private static final String ALGORITHM = "AES/CFB/PKCS5Padding";
    private static final String AES = "AES";

    private static Cipher getCipher(int cipherMode, byte[] key, byte[] iv) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        SecretKeySpec secretKey = new SecretKeySpec(key, AES);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(cipherMode, (Key)secretKey, ivSpec);
        return cipher;
    }

    private static byte[] generateRandomBytes() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateKey() {
        return SymmetricEncryption.generateRandomBytes();
    }

    public static byte[] generateIv() {
        return SymmetricEncryption.generateRandomBytes();
    }

    public static String encrypt(String strToEncrypt, byte[] key, byte[] iv) {
        if (strToEncrypt == null || key == null || iv == null) {
            return null;
        }
        try {
            Cipher cipher = SymmetricEncryption.getCipher(1, key, iv);
            return Base64.encodeBase64String((byte[])cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decrypt(String strToDecrypt, byte[] key, byte[] iv) {
        if (Strings.isNullOrEmpty((String)strToDecrypt) || key == null || iv == null) {
            return null;
        }
        try {
            Cipher cipher = SymmetricEncryption.getCipher(2, key, iv);
            return new String(cipher.doFinal(Base64.decodeBase64((String)strToDecrypt)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

