/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.io.StringReader;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.EmptyStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlParserUtils {
    private static final Logger LOG = LogManager.getLogger(SqlParserUtils.class);

    public static StatementBase getFirstStmt(SqlParser parser) throws Exception {
        List stmts = (List)parser.parse().value;
        return (StatementBase)stmts.get(0);
    }

    public static StatementBase getStmt(SqlParser parser, int idx) throws Exception {
        List stmts = (List)parser.parse().value;
        if (idx >= stmts.size()) {
            throw new AnalysisException("Invalid statement index: " + idx + ". size: " + stmts.size());
        }
        return (StatementBase)stmts.get(idx);
    }

    public static List<StatementBase> getMultiStmts(SqlParser parser) throws Exception {
        List stmts = (List)parser.parse().value;
        while (stmts.size() > 1 && stmts.get(stmts.size() - 1) instanceof EmptyStmt) {
            stmts.remove(stmts.size() - 1);
        }
        return stmts;
    }

    public static StatementBase parseAndAnalyzeStmt(String originStmt, ConnectContext ctx) throws UserException {
        StatementBase statementBase;
        LOG.info("begin to parse stmt: " + originStmt);
        SqlScanner input = new SqlScanner(new StringReader(originStmt), (Long)ctx.getSessionVariable().getSqlMode());
        SqlParser parser = new SqlParser(input);
        Analyzer analyzer = new Analyzer(ctx.getCatalog(), ctx);
        try {
            statementBase = SqlParserUtils.getFirstStmt(parser);
        }
        catch (AnalysisException e) {
            String errorMessage = parser.getErrorMsg(originStmt);
            LOG.error("parse failed: " + errorMessage);
            if (errorMessage == null) {
                throw e;
            }
            throw new AnalysisException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMsg = String.format("get exception when parse stmt. Origin stmt is %s . Error msg is %s.", originStmt, e.getMessage());
            throw new AnalysisException(errorMsg);
        }
        statementBase.analyze(analyzer);
        return statementBase;
    }
}

