/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.doris.blockrule.SqlBlockRule;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;

public class SqlBlockUtil {
    public static final String STRING_DEFAULT = "NULL";
    public static final String LONG_DEFAULT = "0";
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_MINUS_ONE = -1L;

    public static void checkSqlAndSqlHashSetBoth(String sql, String sqlHash) throws AnalysisException {
        if (!STRING_DEFAULT.equals(sql) && !STRING_DEFAULT.equals(sqlHash)) {
            throw new AnalysisException("Only sql or sqlHash can be configured");
        }
    }

    public static void checkSqlAndLimitationsSetBoth(String sql, String sqlHash, String partitionNumString, String tabletNumString, String cardinalityString) throws AnalysisException {
        if (!(STRING_DEFAULT.equals(sql) && STRING_DEFAULT.equals(sqlHash) || SqlBlockUtil.isSqlBlockLimitationsEmpty(partitionNumString, tabletNumString, cardinalityString).booleanValue())) {
            ErrorReport.reportAnalysisException(ErrorCode.ERROR_SQL_AND_LIMITATIONS_SET_IN_ONE_RULE, new Object[0]);
        }
    }

    public static void checkPropertiesValidate(String sql, String sqlHash, String partitionNumString, String tabletNumString, String cardinalityString) throws AnalysisException {
        if ((!STRING_DEFAULT.equals(sql) || !STRING_DEFAULT.equals(sqlHash)) && !SqlBlockUtil.isSqlBlockLimitationsEmpty(partitionNumString, tabletNumString, cardinalityString).booleanValue() || STRING_DEFAULT.equals(sql) && STRING_DEFAULT.equals(sqlHash) && SqlBlockUtil.isSqlBlockLimitationsEmpty(partitionNumString, tabletNumString, cardinalityString).booleanValue()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERROR_SQL_AND_LIMITATIONS_SET_IN_ONE_RULE, new Object[0]);
        }
    }

    public static Boolean isSqlBlockLimitationsEmpty(String partitionNumString, String tabletNumString, String cardinalityString) {
        return StringUtils.isEmpty((CharSequence)partitionNumString) && StringUtils.isEmpty((CharSequence)tabletNumString) && StringUtils.isEmpty((CharSequence)cardinalityString);
    }

    public static Boolean isSqlBlockLimitationsDefault(Long partitionNum, Long tabletNum, Long cardinality) {
        return partitionNum == LONG_ZERO && tabletNum == LONG_ZERO && cardinality == LONG_ZERO;
    }

    public static Boolean isSqlBlockLimitationsNull(Long partitionNum, Long tabletNum, Long cardinality) {
        return partitionNum == null && tabletNum == null && cardinality == null;
    }

    public static void checkAlterValidate(SqlBlockRule sqlBlockRule) throws AnalysisException {
        if (!STRING_DEFAULT.equals(sqlBlockRule.getSql())) {
            if (!STRING_DEFAULT.equals(sqlBlockRule.getSqlHash()) && StringUtils.isNotEmpty((CharSequence)sqlBlockRule.getSqlHash())) {
                throw new AnalysisException("Only sql or sqlHash can be configured");
            }
            if (!SqlBlockUtil.isSqlBlockLimitationsDefault(sqlBlockRule.getPartitionNum(), sqlBlockRule.getTabletNum(), sqlBlockRule.getCardinality()).booleanValue() && !SqlBlockUtil.isSqlBlockLimitationsNull(sqlBlockRule.getPartitionNum(), sqlBlockRule.getTabletNum(), sqlBlockRule.getCardinality()).booleanValue()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERROR_SQL_AND_LIMITATIONS_SET_IN_ONE_RULE, new Object[0]);
            }
        } else if (!STRING_DEFAULT.equals(sqlBlockRule.getSqlHash())) {
            if (!STRING_DEFAULT.equals(sqlBlockRule.getSql()) && StringUtils.isNotEmpty((CharSequence)sqlBlockRule.getSql())) {
                throw new AnalysisException("Only sql or sqlHash can be configured");
            }
            if (!SqlBlockUtil.isSqlBlockLimitationsDefault(sqlBlockRule.getPartitionNum(), sqlBlockRule.getTabletNum(), sqlBlockRule.getCardinality()).booleanValue() && !SqlBlockUtil.isSqlBlockLimitationsNull(sqlBlockRule.getPartitionNum(), sqlBlockRule.getTabletNum(), sqlBlockRule.getCardinality()).booleanValue()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERROR_SQL_AND_LIMITATIONS_SET_IN_ONE_RULE, new Object[0]);
            }
        } else if (!(SqlBlockUtil.isSqlBlockLimitationsDefault(sqlBlockRule.getPartitionNum(), sqlBlockRule.getTabletNum(), sqlBlockRule.getCardinality()).booleanValue() || STRING_DEFAULT.equals(sqlBlockRule.getSql()) && STRING_DEFAULT.equals(sqlBlockRule.getSqlHash()))) {
            ErrorReport.reportAnalysisException(ErrorCode.ERROR_SQL_AND_LIMITATIONS_SET_IN_ONE_RULE, new Object[0]);
        }
    }
}

