/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.analysis.CreateFileStmt;
import org.apache.doris.analysis.DropFileStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmallFileMgr
implements Writable {
    public static final Logger LOG = LogManager.getLogger(SmallFileMgr.class);
    private Table<Long, String, SmallFiles> files = HashBasedTable.create();
    private Map<Long, SmallFile> idToFiles = Maps.newHashMap();

    public void createFile(CreateFileStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        this.downloadAndAddFile(db.getId(), stmt.getCatalogName(), stmt.getFileName(), stmt.getDownloadUrl(), stmt.getChecksum(), stmt.isSaveContent());
    }

    public void dropFile(DropFileStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        this.removeFile(db.getId(), stmt.getCatalogName(), stmt.getFileName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndAddFile(long dbId, String catalog, String fileName, String downloadUrl, String md5sum, boolean saveContent) throws DdlException {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            if (this.idToFiles.size() >= Config.max_small_file_number) {
                throw new DdlException("File number exceeds limit: " + Config.max_small_file_number);
            }
        }
        SmallFile smallFile = this.downloadAndCheck(dbId, catalog, fileName, downloadUrl, md5sum, saveContent);
        Table<Long, String, SmallFiles> table2 = this.files;
        synchronized (table2) {
            if (this.idToFiles.size() >= Config.max_small_file_number) {
                throw new DdlException("File number exceeds limit: " + Config.max_small_file_number);
            }
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)dbId, (Object)catalog);
            if (smallFiles == null) {
                smallFiles = new SmallFiles();
                this.files.put((Object)dbId, (Object)catalog, (Object)smallFiles);
            }
            smallFiles.addFile(fileName, smallFile);
            this.idToFiles.put(smallFile.id, smallFile);
            Catalog.getCurrentCatalog().getEditLog().logCreateSmallFile(smallFile);
            LOG.info("finished to add file {} from url {}. current file number: {}", (Object)fileName, (Object)downloadUrl, (Object)this.idToFiles.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayCreateFile(SmallFile smallFile) {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)smallFile.dbId, (Object)smallFile.catalog);
            if (smallFiles == null) {
                smallFiles = new SmallFiles();
                this.files.put((Object)smallFile.dbId, (Object)smallFile.catalog, (Object)smallFiles);
            }
            try {
                smallFiles.addFile(smallFile.name, smallFile);
                this.idToFiles.put(smallFile.id, smallFile);
            }
            catch (DdlException e) {
                LOG.warn("should not happen", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(long dbId, String catalog, String fileName, boolean isReplay) throws DdlException {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)dbId, (Object)catalog);
            if (smallFiles == null) {
                throw new DdlException("No such file in catalog: " + catalog);
            }
            SmallFile smallFile = smallFiles.removeFile(fileName);
            if (smallFile != null) {
                this.idToFiles.remove(smallFile.id);
                if (!isReplay) {
                    Catalog.getCurrentCatalog().getEditLog().logDropSmallFile(smallFile);
                }
            } else {
                throw new DdlException("No such file: " + fileName);
            }
            LOG.info("finished to remove file {}. current file number: {}. is replay: {}", (Object)fileName, (Object)this.idToFiles.size(), (Object)isReplay);
        }
    }

    public void replayRemoveFile(SmallFile smallFile) {
        try {
            this.removeFile(smallFile.dbId, smallFile.catalog, smallFile.name, true);
        }
        catch (DdlException e) {
            LOG.error("should not happen", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(long dbId, String catalog, String fileName) {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)dbId, (Object)catalog);
            if (smallFiles == null) {
                return false;
            }
            return smallFiles.containsFile(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmallFile getSmallFile(long dbId, String catalog, String fileName, boolean needContent) throws DdlException {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)dbId, (Object)catalog);
            if (smallFiles == null) {
                throw new DdlException("file does not exist with db: " + dbId + " and catalog: " + catalog);
            }
            SmallFile smallFile = smallFiles.getFile(fileName);
            if (smallFile == null) {
                throw new DdlException("File does not exist");
            }
            if (needContent && !smallFile.isContent) {
                throw new DdlException("File exists but not with content");
            }
            return smallFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmallFile getSmallFile(long fileId) {
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            return this.idToFiles.get(fileId);
        }
    }

    private SmallFile downloadAndCheck(long dbId, String catalog, String fileName, String downloadUrl, String md5sum, boolean saveContent) throws DdlException {
        try {
            byte[] buf;
            URL url = new URL(downloadUrl);
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConnection).setRequestMethod("HEAD");
            }
            urlConnection.setReadTimeout(10000);
            urlConnection.getInputStream();
            int contentLength = urlConnection.getContentLength();
            if (contentLength == -1 || contentLength > Config.max_small_file_size_bytes) {
                throw new DdlException("Failed to download file from url: " + url + ", invalid content length: " + contentLength);
            }
            int bytesRead = 0;
            String base64Content = null;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (saveContent) {
                buf = new byte[contentLength];
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    for (bytesRead = 0; bytesRead < contentLength; bytesRead += in.read(buf, bytesRead, contentLength - bytesRead)) {
                    }
                    if (in.read() != -1) {
                        throw new DdlException("Failed to download file from url: " + url + ", content length does not equals to actual file length");
                    }
                }
                if (bytesRead != contentLength) {
                    throw new DdlException("Failed to download file from url: " + url + ", invalid read bytes: " + bytesRead + ", expected: " + contentLength);
                }
                digest.update(buf, 0, bytesRead);
                base64Content = Base64.getEncoder().encodeToString(buf);
            } else {
                buf = new byte[4096];
                int tmpSize = 0;
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    while ((tmpSize = in.read(buf)) >= 0) {
                        digest.update(buf, 0, tmpSize);
                        bytesRead += tmpSize;
                    }
                }
            }
            String checksum = Hex.encodeHexString((byte[])digest.digest());
            if (!Strings.isNullOrEmpty((String)md5sum) && !checksum.equalsIgnoreCase(md5sum)) {
                throw new DdlException("Invalid md5sum of file in url: " + downloadUrl + ", read: " + checksum + ", expected: " + checksum);
            }
            long fileId = Catalog.getCurrentCatalog().getNextId();
            SmallFile smallFile = saveContent ? new SmallFile(dbId, catalog, fileName, fileId, base64Content, bytesRead, checksum, true) : new SmallFile(dbId, catalog, fileName, fileId, downloadUrl, bytesRead, checksum, false);
            return smallFile;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOG.warn("failed to get file from url: {}", (Object)downloadUrl, (Object)e);
            String errorMsg = e.getMessage();
            if (e instanceof FileNotFoundException) {
                errorMsg = "File not found";
            }
            throw new DdlException("Failed to get file from url: " + downloadUrl + ". Error: " + errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveToFile(long dbId, String catalog, String fileName) throws DdlException {
        SmallFile smallFile;
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)dbId, (Object)catalog);
            if (smallFiles == null) {
                throw new DdlException("File " + fileName + " does not exist");
            }
            smallFile = smallFiles.getFile(fileName);
            if (smallFile == null) {
                throw new DdlException("File " + fileName + " does not exist");
            }
            if (!smallFile.isContent) {
                throw new DdlException("File does not contain content: " + smallFile.id);
            }
        }
        File file = this.getAbsoluteFile(dbId, catalog, fileName);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new DdlException("File exist but not a file: " + fileName);
            }
            if (this.checkMd5(file, smallFile.md5)) {
                return file.getAbsolutePath();
            }
            file.delete();
        }
        try {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("failed to make dir for file: " + fileName);
            }
            file.createNewFile();
            byte[] decoded = Base64.getDecoder().decode(smallFile.content);
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(decoded);
            outputStream.flush();
            outputStream.close();
            if (!this.checkMd5(file, smallFile.md5)) {
                throw new DdlException("write file " + fileName + " failed. md5 is invalid. expected: " + smallFile.md5);
            }
        }
        catch (IOException e) {
            LOG.warn("failed to write file: {}", (Object)fileName, (Object)e);
            throw new DdlException("failed to write file: " + fileName);
        }
        return file.getAbsolutePath();
    }

    private boolean checkMd5(File file, String expectedMd5) throws DdlException {
        String md5sum = null;
        try {
            md5sum = DigestUtils.md5Hex((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new DdlException("File " + file.getName() + " does not exist");
        }
        catch (IOException e) {
            LOG.warn("failed to check md5 of file: {}", (Object)file.getName(), (Object)e);
            throw new DdlException("Failed to check md5 of file: " + file.getName());
        }
        return md5sum.equalsIgnoreCase(expectedMd5);
    }

    private File getAbsoluteFile(long dbId, String catalog, String fileName) {
        return Paths.get(Config.small_file_dir, String.valueOf(dbId), catalog, fileName).normalize().toAbsolutePath().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getInfo(String dbName) throws DdlException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        ArrayList infos = Lists.newArrayList();
        Table<Long, String, SmallFiles> table = this.files;
        synchronized (table) {
            if (this.files.containsRow((Object)db.getId())) {
                Map dbFiles = this.files.row((Object)db.getId());
                for (Map.Entry entry : dbFiles.entrySet()) {
                    SmallFiles smallFiles = (SmallFiles)entry.getValue();
                    for (Map.Entry<String, SmallFile> entry2 : smallFiles.getFiles().entrySet()) {
                        ArrayList info = Lists.newArrayList();
                        info.add(String.valueOf(entry2.getValue().id));
                        info.add(dbName);
                        info.add((String)entry.getKey());
                        info.add(entry2.getKey());
                        info.add(String.valueOf(entry2.getValue().size));
                        info.add(String.valueOf(entry2.getValue().isContent));
                        info.add(entry2.getValue().md5);
                        infos.add(info);
                    }
                }
            }
        }
        return infos;
    }

    public static SmallFileMgr read(DataInput in) throws IOException {
        SmallFileMgr mgr = new SmallFileMgr();
        mgr.readFields(in);
        return mgr;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.idToFiles.size());
        for (SmallFile smallFile : this.idToFiles.values()) {
            smallFile.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SmallFile smallFile = SmallFile.read(in);
            this.idToFiles.put(smallFile.id, smallFile);
            SmallFiles smallFiles = (SmallFiles)this.files.get((Object)smallFile.dbId, (Object)smallFile.catalog);
            if (smallFiles == null) {
                smallFiles = new SmallFiles();
                this.files.put((Object)smallFile.dbId, (Object)smallFile.catalog, (Object)smallFiles);
            }
            try {
                smallFiles.addFile(smallFile.name, smallFile);
                continue;
            }
            catch (DdlException e) {
                e.printStackTrace();
            }
        }
    }

    public static class SmallFiles {
        private Map<String, SmallFile> files = Maps.newHashMap();

        public Map<String, SmallFile> getFiles() {
            return this.files;
        }

        public void addFile(String fileName, SmallFile file) throws DdlException {
            if (this.files.containsKey(fileName)) {
                throw new DdlException("File " + fileName + " already exist");
            }
            this.files.put(fileName, file);
        }

        public SmallFile removeFile(String fileName) {
            return this.files.remove(fileName);
        }

        public SmallFile getFile(String fileName) {
            return this.files.get(fileName);
        }

        public boolean containsFile(String fileName) {
            return this.files.containsKey(fileName);
        }
    }

    public static class SmallFile
    implements Writable {
        public long dbId;
        public String catalog;
        public String name;
        public long id;
        public String content;
        public long size;
        public String md5;
        public boolean isContent;

        private SmallFile() {
        }

        public SmallFile(Long dbId, String catalogName, String fileName, Long id, String content, long size, String md5, boolean isContent) {
            this.dbId = dbId;
            this.catalog = catalogName;
            this.name = fileName;
            this.id = id;
            this.content = content;
            this.size = size;
            this.md5 = md5.toLowerCase();
            this.isContent = isContent;
        }

        public static SmallFile read(DataInput in) throws IOException {
            SmallFile smallFile = new SmallFile();
            smallFile.readFields(in);
            return smallFile;
        }

        public byte[] getContentBytes() {
            if (!this.isContent) {
                return null;
            }
            return Base64.getDecoder().decode(this.content);
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.dbId);
            Text.writeString((DataOutput)out, (String)this.catalog);
            Text.writeString((DataOutput)out, (String)this.name);
            out.writeLong(this.id);
            Text.writeString((DataOutput)out, (String)this.content);
            out.writeLong(this.size);
            Text.writeString((DataOutput)out, (String)this.md5);
            out.writeBoolean(this.isContent);
        }

        public void readFields(DataInput in) throws IOException {
            this.dbId = in.readLong();
            this.catalog = Text.readString((DataInput)in);
            this.name = Text.readString((DataInput)in);
            this.id = in.readLong();
            this.content = Text.readString((DataInput)in);
            this.size = in.readLong();
            this.md5 = Text.readString((DataInput)in);
            this.isContent = in.readBoolean();
        }
    }
}

