/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.doris.common.UserException;
import org.apache.parquet.Strings;
import org.apache.parquet.glob.GlobExpander;

public class S3URI {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private static final Set<String> VALID_SCHEMES = ImmutableSet.of((Object)"http", (Object)"https", (Object)"s3", (Object)"s3a", (Object)"s3n", (Object)"bos", (Object[])new String[0]);
    private String scheme;
    private final String location;
    private final String virtualBucket;
    private final String bucket;
    private final String key;
    private boolean forceVirtualHosted;

    public static S3URI create(String location) throws UserException {
        return S3URI.create(location, false);
    }

    public static S3URI create(String location, boolean forceVirtualHosted) throws UserException {
        S3URI s3URI = new S3URI(location, forceVirtualHosted);
        return s3URI;
    }

    private S3URI(String location, boolean forceVirtualHosted) throws UserException {
        if (Strings.isNullOrEmpty((String)location)) {
            throw new UserException("s3 location can not be null");
        }
        try {
            this.location = new URI(location).normalize().toString();
        }
        catch (URISyntaxException e) {
            throw new UserException("Invalid s3 uri: " + e.getMessage());
        }
        this.forceVirtualHosted = forceVirtualHosted;
        String[] schemeSplit = this.location.split(SCHEME_DELIM);
        if (schemeSplit.length != 2) {
            throw new UserException("Invalid s3 uri: " + this.location);
        }
        this.scheme = schemeSplit[0];
        if (!VALID_SCHEMES.contains(this.scheme.toLowerCase())) {
            throw new UserException("Invalid scheme: " + this.location);
        }
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        if (authoritySplit.length != 2) {
            throw new UserException("Invalid s3 uri: " + this.location);
        }
        if (authoritySplit[1].trim().isEmpty()) {
            throw new UserException("Invalid s3 key: " + this.location);
        }
        String path = authoritySplit[1];
        path = path.split(QUERY_DELIM)[0];
        path = path.split(FRAGMENT_DELIM)[0];
        if (this.forceVirtualHosted) {
            this.virtualBucket = authoritySplit[0];
            String[] paths = path.split(PATH_DELIM, 2);
            this.bucket = paths[0];
            this.key = paths.length > 1 ? paths[1] : "";
        } else {
            this.virtualBucket = "";
            this.bucket = authoritySplit[0];
            this.key = path;
        }
    }

    public List<String> expand(String path) {
        return GlobExpander.expand((String)path);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBucketScheme() {
        return this.scheme + SCHEME_DELIM + this.bucket;
    }

    public String getVirtualBucket() {
        return this.virtualBucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }
}

