/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;
import org.apache.doris.common.util.Counter;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.thrift.TCounter;
import org.apache.doris.thrift.TRuntimeProfileNode;
import org.apache.doris.thrift.TRuntimeProfileTree;
import org.apache.doris.thrift.TUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeProfile {
    private static final Logger LOG = LogManager.getLogger(RuntimeProfile.class);
    public static String ROOT_COUNTER = "";
    private Counter counterTotalTime;
    private double localTimePercent = 0.0;
    private Map<String, String> infoStrings = Maps.newHashMap();
    private List<String> infoStringsDisplayOrder = Lists.newArrayList();
    private ReentrantReadWriteLock infoStringsLock = new ReentrantReadWriteLock();
    private Map<String, Counter> counterMap = Maps.newConcurrentMap();
    private Map<String, TreeSet<String>> childCounterMap = Maps.newConcurrentMap();
    private ReentrantReadWriteLock counterLock = new ReentrantReadWriteLock();
    private Map<String, RuntimeProfile> childMap = Maps.newConcurrentMap();
    private LinkedList<Pair<RuntimeProfile, Boolean>> childList = Lists.newLinkedList();
    private ReentrantReadWriteLock childLock = new ReentrantReadWriteLock();
    private String name;

    public RuntimeProfile(String name) {
        this();
        this.name = name;
    }

    public RuntimeProfile() {
        this.counterTotalTime = new Counter(TUnit.TIME_NS, 0L);
        this.counterMap.put("TotalTime", this.counterTotalTime);
    }

    public String getName() {
        return this.name;
    }

    public Counter getCounterTotalTime() {
        return this.counterTotalTime;
    }

    public Map<String, Counter> getCounterMap() {
        return this.counterMap;
    }

    public List<Pair<RuntimeProfile, Boolean>> getChildList() {
        return this.childList;
    }

    public Map<String, RuntimeProfile> getChildMap() {
        return this.childMap;
    }

    public Map<String, TreeSet<String>> getChildCounterMap() {
        return this.childCounterMap;
    }

    public double getLocalTimePercent() {
        return this.localTimePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter addCounter(String name, TUnit type, String parentCounterName) {
        this.counterLock.writeLock().lock();
        try {
            Counter counter = this.counterMap.get(name);
            if (counter != null) {
                Counter counter2 = counter;
                return counter2;
            }
            Preconditions.checkState((parentCounterName.equals(ROOT_COUNTER) || this.counterMap.containsKey(parentCounterName) ? 1 : 0) != 0);
            Counter newCounter = new Counter(type, 0L);
            this.counterMap.put(name, newCounter);
            Set childCounters = this.childCounterMap.get(parentCounterName);
            if (childCounters == null) {
                this.childCounterMap.put(parentCounterName, new TreeSet());
                childCounters = this.childCounterMap.get(parentCounterName);
            }
            childCounters.add(name);
            Counter counter3 = newCounter;
            return counter3;
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    public void update(TRuntimeProfileTree thriftProfile) {
        Reference<Integer> idx = new Reference<Integer>(0);
        this.update(thriftProfile.nodes, idx);
        Preconditions.checkState((boolean)idx.getRef().equals(thriftProfile.nodes.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(List<TRuntimeProfileNode> nodes, Reference<Integer> idx) {
        TRuntimeProfileNode node = nodes.get(idx.getRef());
        if (node.counters != null) {
            for (TCounter tCounter : node.counters) {
                Counter counter = this.counterMap.get(tCounter.name);
                if (counter == null) {
                    this.counterMap.put(tCounter.name, new Counter(tCounter.type, tCounter.value));
                    continue;
                }
                if (counter.getType() != tCounter.type) {
                    LOG.error("Cannot update counters with the same name but different types type=" + tCounter.type);
                    continue;
                }
                counter.setValue(tCounter.value);
            }
            if (node.child_counters_map != null) {
                for (Map.Entry entry : node.child_counters_map.entrySet()) {
                    String parentCounterName = (String)entry.getKey();
                    this.counterLock.writeLock().lock();
                    try {
                        Set childCounters = this.childCounterMap.get(parentCounterName);
                        if (childCounters == null) {
                            this.childCounterMap.put(parentCounterName, new TreeSet());
                            childCounters = this.childCounterMap.get(parentCounterName);
                        }
                        childCounters.addAll((Collection)entry.getValue());
                    }
                    finally {
                        this.counterLock.writeLock().unlock();
                    }
                }
            }
        }
        if (node.info_strings_display_order != null) {
            Map nodeInfoStrings = node.info_strings;
            for (String key : node.info_strings_display_order) {
                String value = (String)nodeInfoStrings.get(key);
                Preconditions.checkState((value != null ? 1 : 0) != 0);
                this.infoStringsLock.writeLock().lock();
                try {
                    if (this.infoStrings.containsKey(key)) {
                        this.infoStrings.put(key, value);
                        continue;
                    }
                    this.infoStrings.put(key, value);
                    this.infoStringsDisplayOrder.add(key);
                }
                finally {
                    this.infoStringsLock.writeLock().unlock();
                }
            }
        }
        idx.setRef(idx.getRef() + 1);
        for (int i = 0; i < node.num_children; ++i) {
            RuntimeProfile childProfile;
            TRuntimeProfileNode tRuntimeProfileNode = nodes.get(idx.getRef());
            String childName = tRuntimeProfileNode.name;
            this.childLock.writeLock().lock();
            try {
                childProfile = this.childMap.get(childName);
                if (childProfile == null) {
                    this.childMap.put(childName, new RuntimeProfile(childName));
                    childProfile = this.childMap.get(childName);
                    Pair<RuntimeProfile, Boolean> pair = Pair.create(childProfile, tRuntimeProfileNode.indent);
                    this.childList.add(pair);
                }
            }
            finally {
                this.childLock.writeLock().unlock();
            }
            childProfile.update(nodes, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prettyPrint(StringBuilder builder, String prefix) {
        Counter counter = this.counterMap.get("TotalTime");
        Preconditions.checkState((counter != null ? 1 : 0) != 0);
        builder.append(prefix).append(this.name).append(":");
        if (counter.getValue() != 0L) {
            try (Formatter fmt = new Formatter();){
                builder.append("(Active: ").append(RuntimeProfile.printCounter(counter.getValue(), counter.getType())).append(", % non-child: ").append(fmt.format("%.2f", this.localTimePercent)).append("%)");
            }
        }
        builder.append("\n");
        this.infoStringsLock.readLock().lock();
        try {
            for (String key : this.infoStringsDisplayOrder) {
                builder.append(prefix).append("   - ").append(key).append(": ").append(this.infoStrings.get(key)).append("\n");
            }
        }
        finally {
            this.infoStringsLock.readLock().unlock();
        }
        this.printChildCounters(prefix, ROOT_COUNTER, builder);
        this.childLock.readLock().lock();
        try {
            for (int i = 0; i < this.childList.size(); ++i) {
                Pair<RuntimeProfile, Boolean> pair = this.childList.get(i);
                boolean indent = (Boolean)pair.second;
                RuntimeProfile profile = (RuntimeProfile)pair.first;
                profile.prettyPrint(builder, prefix + (indent ? "  " : ""));
            }
        }
        finally {
            this.childLock.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.prettyPrint(builder, "");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printChildCounters(String prefix, String counterName, StringBuilder builder) {
        Set childCounterSet = this.childCounterMap.get(counterName);
        if (childCounterSet == null) {
            return;
        }
        this.counterLock.readLock().lock();
        try {
            for (String childCounterName : childCounterSet) {
                Counter counter = this.counterMap.get(childCounterName);
                Preconditions.checkState((counter != null ? 1 : 0) != 0);
                builder.append(prefix).append("   - ").append(childCounterName).append(": ").append(RuntimeProfile.printCounter(counter.getValue(), counter.getType())).append("\n");
                this.printChildCounters(prefix + "  ", childCounterName, builder);
            }
        }
        finally {
            this.counterLock.readLock().unlock();
        }
    }

    public static String printCounter(long value, TUnit type) {
        StringBuilder builder = new StringBuilder();
        long tmpValue = value;
        switch (type) {
            case UNIT: {
                Pair<Double, String> pair = DebugUtil.getUint(tmpValue);
                if (((String)pair.second).isEmpty()) {
                    builder.append(tmpValue);
                    break;
                }
                builder.append(pair.first).append((String)pair.second).append(" (").append(tmpValue).append(")");
                break;
            }
            case TIME_NS: {
                if (tmpValue >= (long)DebugUtil.BILLION) {
                    DebugUtil.printTimeMs(tmpValue /= (long)DebugUtil.MILLION, builder);
                    break;
                }
                if (tmpValue >= (long)DebugUtil.MILLION) {
                    builder.append((tmpValue /= 1000L) / 1000L).append(".").append(tmpValue % 1000L).append("ms");
                    break;
                }
                if (tmpValue > 1000L) {
                    builder.append(tmpValue / 1000L).append(".").append(tmpValue % 1000L).append("us");
                    break;
                }
                builder.append(tmpValue).append("ns");
                break;
            }
            case BYTES: {
                Pair<Double, String> pair = DebugUtil.getByteUint(tmpValue);
                Formatter fmt = new Formatter();
                builder.append(fmt.format("%.2f", pair.first)).append(" ").append((String)pair.second);
                fmt.close();
                break;
            }
            case BYTES_PER_SECOND: {
                Pair<Double, String> pair = DebugUtil.getByteUint(tmpValue);
                builder.append(pair.first).append(" ").append((String)pair.second).append("/sec");
                break;
            }
            case DOUBLE_VALUE: {
                Formatter fmt = new Formatter();
                builder.append(fmt.format("%.2f", tmpValue));
                fmt.close();
                break;
            }
            case UNIT_PER_SECOND: {
                Pair<Double, String> pair = DebugUtil.getUint(tmpValue);
                if (((String)pair.second).isEmpty()) {
                    builder.append(tmpValue);
                    break;
                }
                builder.append(pair.first).append((String)pair.second).append(" ").append("/sec");
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)("type=" + type));
            }
        }
        return builder.toString();
    }

    public void addChild(RuntimeProfile child) {
        if (child == null) {
            return;
        }
        this.childLock.writeLock().lock();
        try {
            if (this.childMap.containsKey(child.name)) {
                this.childList.removeIf(e -> ((RuntimeProfile)e.first).name.equals(child.name));
            }
            this.childMap.put(child.name, child);
            Pair<RuntimeProfile, Boolean> pair = Pair.create(child, true);
            this.childList.add(pair);
        }
        finally {
            this.childLock.writeLock().unlock();
        }
    }

    public void addFirstChild(RuntimeProfile child) {
        if (child == null) {
            return;
        }
        this.childLock.writeLock().lock();
        try {
            if (this.childMap.containsKey(child.name)) {
                this.childList.removeIf(e -> ((RuntimeProfile)e.first).name.equals(child.name));
            }
            this.childMap.put(child.name, child);
            Pair<RuntimeProfile, Boolean> pair = Pair.create(child, true);
            this.childList.addFirst(pair);
        }
        finally {
            this.childLock.writeLock().unlock();
        }
    }

    public void computeTimeInChildProfile() {
        this.childMap.values().forEach(RuntimeProfile::computeTimeInProfile);
    }

    public void computeTimeInProfile() {
        this.computeTimeInProfile(this.counterTotalTime.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTimeInProfile(long total) {
        if (total == 0L) {
            return;
        }
        this.childLock.readLock().lock();
        try {
            long totalChildTime = 0L;
            for (int i = 0; i < this.childList.size(); ++i) {
                totalChildTime += ((RuntimeProfile)this.childList.get((int)i).first).getCounterTotalTime().getValue();
            }
            long localTime = this.getCounterTotalTime().getValue() - totalChildTime;
            localTime = Math.max(0L, localTime);
            this.localTimePercent = Double.valueOf(localTime) / Double.valueOf(total);
            this.localTimePercent = Math.min(1.0, this.localTimePercent) * 100.0;
            for (int i = 0; i < this.childList.size(); ++i) {
                ((RuntimeProfile)this.childList.get((int)i).first).computeTimeInProfile(total);
            }
        }
        finally {
            this.childLock.readLock().unlock();
        }
    }

    public void sortChildren() {
        this.childLock.writeLock().lock();
        try {
            this.childList.sort((profile1, profile2) -> Long.compare(((RuntimeProfile)profile2.first).getCounterTotalTime().getValue(), ((RuntimeProfile)profile1.first).getCounterTotalTime().getValue()));
        }
        finally {
            this.childLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInfoString(String key, String value) {
        this.infoStringsLock.writeLock().lock();
        try {
            String target = this.infoStrings.get(key);
            if (target == null) {
                this.infoStrings.put(key, value);
                this.infoStringsDisplayOrder.add(key);
            } else {
                this.infoStrings.put(key, value);
            }
        }
        finally {
            this.infoStringsLock.writeLock().unlock();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfoString(String key) {
        return this.infoStrings.get(key);
    }
}

