/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.common.DdlException;

public class RangeUtils {
    public static final Comparator<Map.Entry<Long, PartitionItem>> RANGE_MAP_ENTRY_COMPARATOR = Comparator.comparing(o -> (PartitionKey)((RangePartitionItem)o.getValue()).getItems().lowerEndpoint());
    public static final Comparator<PartitionItem> RANGE_COMPARATOR = Comparator.comparing(o -> (PartitionKey)((RangePartitionItem)o).getItems().lowerEndpoint());

    public static void checkRangeIntersect(Range<PartitionKey> range1, Range<PartitionKey> range2) throws DdlException {
        if (range2.isConnected(range1) && !range2.intersection(range1).isEmpty()) {
            throw new DdlException("Range " + range1 + " is intersected with range: " + range2);
        }
    }

    public static boolean checkIsTwoRangesIntersect(Range<PartitionKey> range1, Range<PartitionKey> range2) {
        return range2.isConnected(range1) && !range2.intersection(range1).isEmpty();
    }

    public static void checkPartitionItemListsMatch(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        Collections.sort(list1, RANGE_COMPARATOR);
        Collections.sort(list2, RANGE_COMPARATOR);
        int idx1 = 0;
        int idx2 = 0;
        Range range1 = (Range)list1.get(idx1).getItems();
        Range range2 = (Range)list2.get(idx2).getItems();
        while (true) {
            if (((PartitionKey)range1.lowerEndpoint()).compareTo((PartitionKey)range2.lowerEndpoint()) != 0) {
                throw new DdlException("2 range lists are not stricly matched. " + range1.lowerEndpoint() + " vs. " + range2.lowerEndpoint());
            }
            int res = ((PartitionKey)range1.upperEndpoint()).compareTo((PartitionKey)range2.upperEndpoint());
            if (res == 0) {
                if (++idx1 == list1.size() || ++idx2 == list2.size()) break;
                range1 = (Range)list1.get(idx1).getItems();
                range2 = (Range)list2.get(idx2).getItems();
                continue;
            }
            if (res > 0) {
                if (++idx2 == list2.size()) break;
                range1 = Range.closedOpen((Comparable)((PartitionKey)range2.upperEndpoint()), (Comparable)((PartitionKey)range1.upperEndpoint()));
                range2 = (Range)list2.get(idx2).getItems();
                continue;
            }
            if (++idx1 == list1.size()) break;
            range2 = Range.closedOpen((Comparable)((PartitionKey)range1.upperEndpoint()), (Comparable)((PartitionKey)range2.upperEndpoint()));
            range1 = (Range)list1.get(idx1).getItems();
        }
        if (idx1 < list1.size() || idx2 < list2.size()) {
            throw new DdlException("2 range lists are not stricly matched. " + list1 + " vs. " + list2);
        }
    }

    public static void writeRange(DataOutput out, Range<PartitionKey> range) throws IOException {
        boolean hasLowerBound = false;
        boolean hasUpperBound = false;
        hasLowerBound = range.hasLowerBound();
        out.writeBoolean(hasLowerBound);
        if (hasLowerBound) {
            PartitionKey lowerBound = (PartitionKey)range.lowerEndpoint();
            out.writeBoolean(range.lowerBoundType() == BoundType.CLOSED);
            lowerBound.write(out);
        }
        hasUpperBound = range.hasUpperBound();
        out.writeBoolean(hasUpperBound);
        if (hasUpperBound) {
            PartitionKey upperBound = (PartitionKey)range.upperEndpoint();
            out.writeBoolean(range.upperBoundType() == BoundType.CLOSED);
            upperBound.write(out);
        }
    }

    public static Range<PartitionKey> readRange(DataInput in) throws IOException {
        boolean hasLowerBound = false;
        boolean hasUpperBound = false;
        boolean lowerBoundClosed = false;
        boolean upperBoundClosed = false;
        PartitionKey lowerBound = null;
        PartitionKey upperBound = null;
        hasLowerBound = in.readBoolean();
        if (hasLowerBound) {
            lowerBoundClosed = in.readBoolean();
            lowerBound = PartitionKey.read(in);
        }
        if (hasUpperBound = in.readBoolean()) {
            upperBoundClosed = in.readBoolean();
            upperBound = PartitionKey.read(in);
        }
        if (hasLowerBound && lowerBoundClosed && hasUpperBound && upperBoundClosed) {
            return Range.closed((Comparable)lowerBound, (Comparable)upperBound);
        }
        if (hasLowerBound && lowerBoundClosed && hasUpperBound && !upperBoundClosed) {
            return Range.closedOpen((Comparable)lowerBound, (Comparable)upperBound);
        }
        if (hasLowerBound && !lowerBoundClosed && hasUpperBound && upperBoundClosed) {
            return Range.openClosed((Comparable)lowerBound, (Comparable)upperBound);
        }
        if (hasLowerBound && !lowerBoundClosed && hasUpperBound && !upperBoundClosed) {
            return Range.open((Comparable)lowerBound, (Comparable)upperBound);
        }
        if (hasLowerBound && lowerBoundClosed && !hasUpperBound) {
            return Range.atLeast((Comparable)lowerBound);
        }
        if (hasLowerBound && !lowerBoundClosed && !hasUpperBound) {
            return Range.greaterThan((Comparable)lowerBound);
        }
        if (!hasLowerBound && hasUpperBound && upperBoundClosed) {
            return Range.atMost((Comparable)upperBound);
        }
        if (!hasLowerBound && hasUpperBound && !upperBoundClosed) {
            return Range.lessThan((Comparable)upperBound);
        }
        return null;
    }

    public static void checkRangeConflict(List<PartitionItem> baseRanges, List<PartitionItem> rangesToBeChecked) throws DdlException {
        TreeRangeMap baseRangeMap = TreeRangeMap.create();
        long idx = 0L;
        for (PartitionItem item : baseRanges) {
            baseRangeMap.put((Range)item.getItems(), (Object)idx++);
        }
        for (PartitionItem item : rangesToBeChecked) {
            if (baseRangeMap.subRangeMap((Range)item.getItems()).asMapOfRanges().isEmpty()) continue;
            throw new DdlException("Range: " + item.getItems() + " conflicts with existing range");
        }
    }
}

