/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.thrift.TUnit;

public class QueryPlannerProfile {
    public static final String KEY_ANALYSIS = "Analysis Time";
    public static final String KEY_PLAN = "Plan Time";
    public static final String KEY_SCHEDULE = "Schedule Time";
    public static final String KEY_FETCH = "Wait and Fetch Result Time";
    private long queryBeginTime = -1L;
    private long queryAnalysisFinishTime = -1L;
    private long queryPlanFinishTime = -1L;
    private long queryScheduleFinishTime = -1L;
    private long queryFetchResultFinishTime = -1L;

    public void setQueryBeginTime() {
        this.queryBeginTime = TimeUtils.getStartTime();
    }

    public void setQueryAnalysisFinishTime() {
        this.queryAnalysisFinishTime = TimeUtils.getStartTime();
    }

    public void setQueryPlanFinishTime() {
        this.queryPlanFinishTime = TimeUtils.getStartTime();
    }

    public void setQueryScheduleFinishTime() {
        this.queryScheduleFinishTime = TimeUtils.getStartTime();
    }

    public void setQueryFetchResultFinishTime() {
        this.queryFetchResultFinishTime = TimeUtils.getStartTime();
    }

    public long getQueryBeginTime() {
        return this.queryBeginTime;
    }

    private String getPrettyQueryAnalysisFinishTime() {
        if (this.queryBeginTime == -1L || this.queryAnalysisFinishTime == -1L) {
            return "N/A";
        }
        return RuntimeProfile.printCounter(this.queryAnalysisFinishTime - this.queryBeginTime, TUnit.TIME_NS);
    }

    private String getPrettyQueryPlanFinishTime() {
        if (this.queryAnalysisFinishTime == -1L || this.queryPlanFinishTime == -1L) {
            return "N/A";
        }
        return RuntimeProfile.printCounter(this.queryPlanFinishTime - this.queryAnalysisFinishTime, TUnit.TIME_NS);
    }

    private String getPrettyQueryScheduleFinishTime() {
        if (this.queryPlanFinishTime == -1L || this.queryScheduleFinishTime == -1L) {
            return "N/A";
        }
        return RuntimeProfile.printCounter(this.queryScheduleFinishTime - this.queryPlanFinishTime, TUnit.TIME_NS);
    }

    private String getPrettyQueryFetchResultFinishTime() {
        if (this.queryScheduleFinishTime == -1L || this.queryFetchResultFinishTime == -1L) {
            return "N/A";
        }
        return RuntimeProfile.printCounter(this.queryFetchResultFinishTime - this.queryScheduleFinishTime, TUnit.TIME_NS);
    }

    public void initRuntimeProfile(RuntimeProfile plannerProfile) {
        plannerProfile.addInfoString(KEY_ANALYSIS, this.getPrettyQueryAnalysisFinishTime());
        plannerProfile.addInfoString(KEY_PLAN, this.getPrettyQueryPlanFinishTime());
        plannerProfile.addInfoString(KEY_SCHEDULE, this.getPrettyQueryScheduleFinishTime());
        plannerProfile.addInfoString(KEY_FETCH, this.getPrettyQueryFetchResultFinishTime());
    }
}

