/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.profile.MultiProfileTreeBuilder;
import org.apache.doris.common.profile.ProfileTreeBuilder;
import org.apache.doris.common.profile.ProfileTreeNode;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfileManager {
    private static final Logger LOG = LogManager.getLogger(ProfileManager.class);
    private static volatile ProfileManager INSTANCE = null;
    private static final int ARRAY_SIZE = 100;
    public static final String QUERY_ID = "Query ID";
    public static final String START_TIME = "Start Time";
    public static final String END_TIME = "End Time";
    public static final String TOTAL_TIME = "Total";
    public static final String QUERY_TYPE = "Query Type";
    public static final String QUERY_STATE = "Query State";
    public static final String DORIS_VERSION = "Doris Version";
    public static final String USER = "User";
    public static final String DEFAULT_DB = "Default Db";
    public static final String SQL_STATEMENT = "Sql Statement";
    public static final String IS_CACHED = "Is Cached";
    public static final ArrayList<String> PROFILE_HEADERS = new ArrayList<String>(Arrays.asList("Query ID", "User", "Default Db", "Sql Statement", "Query Type", "Start Time", "End Time", "Total", "Query State"));
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private Deque<String> queryIdDeque = new LinkedList<String>();
    private Map<String, ProfileElement> queryIdToProfileMap = new ConcurrentHashMap<String, ProfileElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProfileManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProfileManager> clazz = ProfileManager.class;
        synchronized (ProfileManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ProfileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ProfileManager() {
    }

    public ProfileElement createElement(RuntimeProfile profile) {
        ProfileElement element = new ProfileElement();
        RuntimeProfile summaryProfile = (RuntimeProfile)profile.getChildList().get((int)0).first;
        for (String header : PROFILE_HEADERS) {
            element.infoStrings.put(header, summaryProfile.getInfoString(header));
        }
        element.profileContent = profile.toString();
        MultiProfileTreeBuilder builder = new MultiProfileTreeBuilder(profile);
        try {
            builder.build();
        }
        catch (Exception e) {
            element.errMsg = e.getMessage();
            LOG.debug("failed to build profile tree", (Throwable)e);
            return element;
        }
        element.builder = builder;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProfile(RuntimeProfile profile) {
        if (profile == null) {
            return;
        }
        ProfileElement element = this.createElement(profile);
        String queryId = element.infoStrings.get(QUERY_ID);
        if (Strings.isNullOrEmpty((String)queryId)) {
            LOG.warn("the key or value of Map is null, may be forget to insert 'QUERY_ID' column into infoStrings");
        }
        this.queryIdToProfileMap.put(queryId, element);
        this.writeLock.lock();
        try {
            if (!this.queryIdDeque.contains(queryId)) {
                if (this.queryIdDeque.size() >= 100) {
                    this.queryIdToProfileMap.remove(this.queryIdDeque.getFirst());
                    this.queryIdDeque.removeFirst();
                }
                this.queryIdDeque.addLast(queryId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<List<String>> getAllQueries() {
        return this.getQueryWithType(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getQueryWithType(ProfileType type) {
        ArrayList result = Lists.newArrayList();
        this.readLock.lock();
        try {
            Iterator<String> reverse = this.queryIdDeque.descendingIterator();
            while (reverse.hasNext()) {
                String queryId = reverse.next();
                ProfileElement profileElement = this.queryIdToProfileMap.get(queryId);
                if (profileElement == null) continue;
                Map<String, String> infoStrings = profileElement.infoStrings;
                if (type != null && !infoStrings.get(QUERY_TYPE).equalsIgnoreCase(type.name())) continue;
                ArrayList row = Lists.newArrayList();
                for (String str : PROFILE_HEADERS) {
                    row.add(infoStrings.get(str));
                }
                result.add(row);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfile(String queryID) {
        this.readLock.lock();
        try {
            ProfileElement element = this.queryIdToProfileMap.get(queryID);
            if (element == null) {
                String string = null;
                return string;
            }
            String string = element.profileContent;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTreeNode getFragmentProfileTree(String queryID, String executionId) throws AnalysisException {
        MultiProfileTreeBuilder builder;
        this.readLock.lock();
        try {
            ProfileElement element = this.queryIdToProfileMap.get(queryID);
            if (element == null || element.builder == null) {
                throw new AnalysisException("failed to get fragment profile tree. err: " + (element == null ? "not found" : element.errMsg));
            }
            builder = element.builder;
        }
        finally {
            this.readLock.unlock();
        }
        return builder.getFragmentTreeRoot(executionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Triple<String, String, Long>> getFragmentInstanceList(String queryID, String executionId, String fragmentId) throws AnalysisException {
        MultiProfileTreeBuilder builder;
        this.readLock.lock();
        try {
            ProfileElement element = this.queryIdToProfileMap.get(queryID);
            if (element == null || element.builder == null) {
                throw new AnalysisException("failed to get instance list. err: " + (element == null ? "not found" : element.errMsg));
            }
            builder = element.builder;
        }
        finally {
            this.readLock.unlock();
        }
        return builder.getInstanceList(executionId, fragmentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTreeNode getInstanceProfileTree(String queryID, String executionId, String fragmentId, String instanceId) throws AnalysisException {
        MultiProfileTreeBuilder builder;
        this.readLock.lock();
        try {
            ProfileElement element = this.queryIdToProfileMap.get(queryID);
            if (element == null || element.builder == null) {
                throw new AnalysisException("failed to get instance profile tree. err: " + (element == null ? "not found" : element.errMsg));
            }
            builder = element.builder;
        }
        finally {
            this.readLock.unlock();
        }
        return builder.getInstanceTreeRoot(executionId, fragmentId, instanceId);
    }

    public List<List<String>> getLoadJobTaskList(String jobId) throws AnalysisException {
        MultiProfileTreeBuilder builder = this.getMultiProfileTreeBuilder(jobId);
        return builder.getSubTaskInfo();
    }

    public List<ProfileTreeBuilder.FragmentInstances> getFragmentsAndInstances(String queryId) throws AnalysisException {
        return this.getMultiProfileTreeBuilder(queryId).getFragmentInstances(queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiProfileTreeBuilder getMultiProfileTreeBuilder(String jobId) throws AnalysisException {
        this.readLock.lock();
        try {
            ProfileElement element = this.queryIdToProfileMap.get(jobId);
            if (element == null || element.builder == null) {
                throw new AnalysisException("failed to get task ids. err: " + (element == null ? "not found" : element.errMsg));
            }
            MultiProfileTreeBuilder multiProfileTreeBuilder = element.builder;
            return multiProfileTreeBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private class ProfileElement {
        public Map<String, String> infoStrings = Maps.newHashMap();
        public String profileContent = "";
        public MultiProfileTreeBuilder builder = null;
        public String errMsg = "";

        private ProfileElement() {
        }
    }

    public static enum ProfileType {
        QUERY,
        LOAD;

    }
}

