/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrintableMap<K, V> {
    private Map<K, V> map;
    private String keyValueSeparator;
    private boolean withQuotation;
    private boolean wrap;
    private boolean hidePassword;
    private String entryDelimiter = ",";
    public static final Set<String> SENSITIVE_KEY = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);

    public PrintableMap(Map<K, V> map, String keyValueSeparator, boolean withQuotation, boolean wrap, String entryDelimiter) {
        this.map = map;
        this.keyValueSeparator = keyValueSeparator;
        this.withQuotation = withQuotation;
        this.wrap = wrap;
        this.hidePassword = false;
        this.entryDelimiter = entryDelimiter;
    }

    public PrintableMap(Map<K, V> map, String keyValueSeparator, boolean withQuotation, boolean wrap) {
        this(map, keyValueSeparator, withQuotation, wrap, ",");
    }

    public PrintableMap(Map<K, V> map, String keyValueSeparator, boolean withQuotation, boolean wrap, boolean hidePassword) {
        this(map, keyValueSeparator, withQuotation, wrap);
        this.hidePassword = hidePassword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<K, V>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (this.withQuotation) {
                sb.append("\"");
            }
            sb.append(entry.getKey());
            if (this.withQuotation) {
                sb.append("\"");
            }
            sb.append(" ").append(this.keyValueSeparator).append(" ");
            if (this.withQuotation) {
                sb.append("\"");
            }
            if (this.hidePassword && SENSITIVE_KEY.contains(entry.getKey())) {
                sb.append("*XXX");
            } else {
                sb.append(entry.getValue());
            }
            if (this.withQuotation) {
                sb.append("\"");
            }
            if (!iter.hasNext()) continue;
            sb.append(this.entryDelimiter);
            if (this.wrap) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    static {
        SENSITIVE_KEY.add("password");
        SENSITIVE_KEY.add("kerberos_keytab_content");
        SENSITIVE_KEY.add("bos_secret_accesskey");
    }
}

