/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.doris.common.AnalysisException;

public class ParseUtil {
    private static ImmutableMap<String, Long> validDataVolumnUnitMultiplier = ImmutableMap.builder().put((Object)"B", (Object)1L).put((Object)"K", (Object)1024L).put((Object)"KB", (Object)1024L).put((Object)"M", (Object)0x100000L).put((Object)"MB", (Object)0x100000L).put((Object)"G", (Object)0x40000000L).put((Object)"GB", (Object)0x40000000L).put((Object)"T", (Object)0x10000000000L).put((Object)"TB", (Object)0x10000000000L).put((Object)"P", (Object)0x4000000000000L).put((Object)"PB", (Object)0x4000000000000L).build();
    private static Pattern dataVolumnPattern = Pattern.compile("(\\d+)(\\D*)");

    public static long analyzeDataVolumn(String dataVolumnStr) throws AnalysisException {
        String unit;
        long dataVolumn = 0L;
        Matcher m = dataVolumnPattern.matcher(dataVolumnStr);
        if (m.matches()) {
            try {
                dataVolumn = Long.parseLong(m.group(1));
            }
            catch (NumberFormatException nfe) {
                throw new AnalysisException("invalid data volumn:" + m.group(1));
            }
            if (dataVolumn <= 0L) {
                throw new AnalysisException("Data volumn must larger than 0");
            }
            unit = "B";
            String tmpUnit = m.group(2);
            if (!Strings.isNullOrEmpty((String)tmpUnit)) {
                unit = tmpUnit.toUpperCase();
            }
            if (!validDataVolumnUnitMultiplier.containsKey((Object)unit)) {
                throw new AnalysisException("invalid unit:" + tmpUnit);
            }
        } else {
            throw new AnalysisException("invalid data volumn expression:" + dataVolumnStr);
        }
        return dataVolumn *= ((Long)validDataVolumnUnitMultiplier.get((Object)unit)).longValue();
    }

    public static long analyzeReplicaNumber(String replicaNumberStr) throws AnalysisException {
        long replicaNumber = 0L;
        try {
            replicaNumber = Long.parseLong(replicaNumberStr);
        }
        catch (NumberFormatException nfe) {
            throw new AnalysisException("invalid data volumn:" + replicaNumberStr);
        }
        if (replicaNumber <= 0L) {
            throw new AnalysisException("Replica volumn must larger than 0");
        }
        return replicaNumber;
    }
}

