/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetUtils {
    private static final Logger LOG = LogManager.getLogger(NetUtils.class);
    public static final String EDIT_LOG_PORT_SUGGESTION = "Please change the 'edit_log_port' in fe.conf and try again. But if this is not the first time your start this FE, please DO NOT change it.  You need to find the service that occupies the port and shut it down, and then return the port to Doris.";
    public static final String QUERY_PORT_SUGGESTION = "Please change the 'query_port' in fe.conf and try again.";
    public static final String HTTP_PORT_SUGGESTION = "Please change the 'http_port' in fe.conf and try again. But you need to make sure that ALL FEs http_port are same.";
    public static final String RPC_PORT_SUGGESTION = "Please change the 'rpc_port' in fe.conf and try again.";

    public static InetSocketAddress createSocketAddr(String target) {
        int colonIndex = target.indexOf(58);
        if (colonIndex < 0) {
            throw new RuntimeException("Not a host:port pair : " + target);
        }
        String hostname = target.substring(0, colonIndex);
        int port = Integer.parseInt(target.substring(colonIndex + 1));
        return new InetSocketAddress(hostname, port);
    }

    public static void getHosts(List<InetAddress> hosts) {
        Enumeration<NetworkInterface> n = null;
        try {
            n = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            throw new RuntimeException("failed to get network interfaces");
        }
        while (n.hasMoreElements()) {
            NetworkInterface e = n.nextElement();
            Enumeration<InetAddress> a = e.getInetAddresses();
            while (a.hasMoreElements()) {
                InetAddress addr = a.nextElement();
                hosts.add(addr);
            }
        }
    }

    public static String getHostnameByIp(String ip) {
        String hostName;
        try {
            InetAddress address = InetAddress.getByName(ip);
            hostName = address.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.info("unknown host for {}", (Object)ip, (Object)e);
            hostName = "unknown";
        }
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(String host, int port, String portName, String suggestion) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn("{} {} is already in use. {}", (Object)portName, (Object)port, (Object)suggestion, (Object)e);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

