/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlUtil {
    private static final Logger LOG = LogManager.getLogger(MysqlUtil.class);
    private static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static final int CONNECT_TIMEOUT_MS = 1000;
    private static final int SOCKET_TIMEOUT_MS = 10000;

    private static String buildMysqlUrl(String host, int port, String db) {
        StringBuilder builder = new StringBuilder();
        builder.append(MYSQL_URL_PREFIX).append(host).append(":").append(port).append("/").append(db).append("?").append("connectTimeout=").append(1000).append("&").append("socketTimeout=").append(10000);
        return builder.toString();
    }

    public static Connection getConnection(String host, int port, String db, String user, String passwd) {
        String url = MysqlUtil.buildMysqlUrl(host, port, db);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, user, passwd);
        }
        catch (SQLException e) {
            LOG.warn("fail to get connection to mysql. url={}, user={}, passwd={}, exception={}", (Object)url, (Object)user, (Object)passwd, (Object)e.getMessage());
            return null;
        }
        return conn;
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sqlEx) {
                LOG.warn("fail to close connection to mysql.");
            }
        }
    }

    static {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException e) {
            Preconditions.checkState((boolean)false, (Object)"fail to load JDBC driver.");
        }
    }
}

