/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.MetaNotFoundException;

public class MetaLockUtils {
    public static void readLockDatabases(List<Database> databaseList) {
        for (Database database : databaseList) {
            database.readLock();
        }
    }

    public static void readUnlockDatabases(List<Database> databaseList) {
        for (int i = databaseList.size() - 1; i >= 0; --i) {
            databaseList.get(i).readUnlock();
        }
    }

    public static void readLockTables(List<Table> tableList) {
        for (Table table : tableList) {
            table.readLock();
        }
    }

    public static void readUnlockTables(List<Table> tableList) {
        for (int i = tableList.size() - 1; i >= 0; --i) {
            tableList.get(i).readUnlock();
        }
    }

    public static void writeLockTables(List<Table> tableList) {
        for (Table table : tableList) {
            table.writeLock();
        }
    }

    public static List<Table> writeLockTablesIfExist(List<Table> tableList) {
        ArrayList lockedTablesList = Lists.newArrayListWithCapacity((int)tableList.size());
        for (Table table : tableList) {
            if (!table.writeLockIfExist()) continue;
            lockedTablesList.add(table);
        }
        return lockedTablesList;
    }

    public static void writeLockTablesOrMetaException(List<Table> tableList) throws MetaNotFoundException {
        for (int i = 0; i < tableList.size(); ++i) {
            try {
                tableList.get(i).writeLockOrMetaException();
                continue;
            }
            catch (MetaNotFoundException e) {
                for (int j = i - 1; j >= 0; --j) {
                    tableList.get(j).writeUnlock();
                }
                throw e;
            }
        }
    }

    public static boolean tryWriteLockTablesOrMetaException(List<Table> tableList, long timeout, TimeUnit unit) throws MetaNotFoundException {
        for (int i = 0; i < tableList.size(); ++i) {
            try {
                if (tableList.get(i).tryWriteLockOrMetaException(timeout, unit)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    tableList.get(j).writeUnlock();
                }
                return false;
            }
            catch (MetaNotFoundException e) {
                for (int j = i - 1; j >= 0; --j) {
                    tableList.get(j).writeUnlock();
                }
                throw e;
            }
        }
        return true;
    }

    public static void writeUnlockTables(List<Table> tableList) {
        for (int i = tableList.size() - 1; i >= 0; --i) {
            tableList.get(i).writeUnlock();
        }
    }
}

