/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.LogKey;

public class LogBuilder {
    private final StringBuilder sb;
    private final List<LogEntry> entries;

    public LogBuilder(String identifier) {
        this.sb = new StringBuilder(identifier).append("-");
        this.entries = Lists.newLinkedList();
    }

    public LogBuilder(LogKey key, Long identifier) {
        this.sb = new StringBuilder().append(key.name()).append("=").append(identifier).append(", ");
        this.entries = Lists.newLinkedList();
    }

    public LogBuilder(LogKey key, UUID identifier) {
        this.sb = new StringBuilder().append(key.name()).append("=").append(DebugUtil.printId(identifier)).append(", ");
        this.entries = Lists.newLinkedList();
    }

    public LogBuilder(LogKey key, String identifier) {
        this.sb = new StringBuilder().append(key.name()).append("=").append(identifier).append(", ");
        this.entries = Lists.newLinkedList();
    }

    public LogBuilder add(String key, long value) {
        this.entries.add(new LogEntry(key, String.valueOf(value)));
        return this;
    }

    public LogBuilder add(String key, int value) {
        this.entries.add(new LogEntry(key, String.valueOf(value)));
        return this;
    }

    public LogBuilder add(String key, float value) {
        this.entries.add(new LogEntry(key, String.valueOf(value)));
        return this;
    }

    public LogBuilder add(String key, boolean value) {
        this.entries.add(new LogEntry(key, String.valueOf(value)));
        return this;
    }

    public LogBuilder add(String key, String value) {
        this.entries.add(new LogEntry(key, String.valueOf(value)));
        return this;
    }

    public LogBuilder add(String key, Object value) {
        if (value == null) {
            this.entries.add(new LogEntry(key, "null"));
        } else {
            this.entries.add(new LogEntry(key, value.toString()));
        }
        return this;
    }

    public String build() {
        Iterator<LogEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            LogEntry logEntry = it.next();
            this.sb.append(logEntry.key).append("={").append(logEntry.value).append("}");
            if (!it.hasNext()) continue;
            this.sb.append(", ");
        }
        return this.sb.toString();
    }

    public String toString() {
        return this.build();
    }

    private class LogEntry {
        String key;
        String value;

        public LogEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

