/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.DdlException;

public class ListUtil {
    public static final Comparator<Map.Entry<Long, PartitionItem>> LIST_MAP_ENTRY_COMPARATOR = Comparator.comparing(o -> (PartitionKey)((ListPartitionItem)o.getValue()).getItems().iterator().next());
    public static final Comparator<PartitionItem> PARTITION_KEY_COMPARATOR = Comparator.comparing(o -> (PartitionKey)((ListPartitionItem)o).getItems().iterator().next());

    public static <T> List<List<T>> splitBySize(List<T> list, int expectedSize) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull(list, (Object)"list must not be null");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must larger than 0");
        int splitSize = Math.min(expectedSize, list.size());
        ArrayList<List<T>> result = new ArrayList<List<T>>(splitSize);
        for (int i = 0; i < splitSize; ++i) {
            result.add(new ArrayList());
        }
        int index = 0;
        for (T t : list) {
            ((List)result.get(index)).add(t);
            index = (index + 1) % splitSize;
        }
        return result;
    }

    public static void checkPartitionKeyListsMatch(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        Collections.sort(list1, PARTITION_KEY_COMPARATOR);
        Collections.sort(list2, PARTITION_KEY_COMPARATOR);
        int idx1 = 0;
        int idx2 = 0;
        ArrayList keys1 = new ArrayList();
        ArrayList keys2 = new ArrayList();
        keys1.addAll((Collection)list1.get(idx1).getItems());
        keys2.addAll((Collection)list2.get(idx2).getItems());
        while (true) {
            int size = Math.min(keys1.size(), keys2.size());
            for (int i = 0; i < size; ++i) {
                int res = ((PartitionKey)keys1.get(i)).compareTo((PartitionKey)keys2.get(i));
                if (res == 0) continue;
                throw new DdlException("2 partition key lists are not matched. " + keys1 + " vs. " + keys2);
            }
            int res = keys1.size() - keys2.size();
            if (res == 0) {
                if (++idx1 == list1.size() || ++idx2 == list2.size()) break;
                keys1.clear();
                keys2.clear();
                keys1.addAll((Collection)list1.get(idx1).getItems());
                keys2.addAll((Collection)list2.get(idx2).getItems());
                continue;
            }
            if (res > 0) {
                if (++idx2 == list2.size()) break;
                keys1.removeAll(keys2);
                keys2.clear();
                keys2.addAll((Collection)list2.get(idx2).getItems());
                continue;
            }
            if (++idx1 == list1.size()) break;
            keys2.removeAll(keys1);
            keys1.clear();
            keys1.addAll((Collection)list1.get(idx1).getItems());
        }
        if (idx1 < list1.size() || idx2 < list2.size()) {
            throw new DdlException("2 partition key lists are not matched. " + list1 + " vs. " + list2);
        }
    }

    public static void checkListsConflict(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        for (PartitionItem checkItem : list2) {
            List checkKeys = (List)checkItem.getItems();
            for (PartitionKey checkKey : checkKeys) {
                for (PartitionItem currentItem : list1) {
                    if (!((ListPartitionItem)currentItem).getItems().contains(checkKey)) continue;
                    throw new DdlException("The partition key[" + checkKey.toSql() + "] is overlap with current " + currentItem.toString());
                }
            }
        }
    }
}

