/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import org.apache.doris.common.util.OrderByPair;

public class ListComparator<T extends List<Comparable>>
implements Comparator<T> {
    OrderByPair[] orderByPairs;
    boolean isDesc;
    int indicesLen;

    public ListComparator(int ... indices) {
        this(false, indices);
    }

    public ListComparator(boolean isDesc, int ... indices) {
        this.orderByPairs = new OrderByPair[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            this.orderByPairs[i] = new OrderByPair(indices[i], isDesc);
        }
        this.indicesLen = this.orderByPairs.length;
    }

    public ListComparator(OrderByPair ... orderByPairs) {
        this.orderByPairs = orderByPairs;
        this.indicesLen = orderByPairs.length;
    }

    @Override
    public int compare(T firstList, T secondList) {
        int firstLen = firstList.size();
        int secondLen = secondList.size();
        int minLen = Math.min(firstLen, secondLen);
        OrderByPair orderByPair = null;
        for (int i = 0; i < this.indicesLen; ++i) {
            int ret;
            if (i >= minLen || (ret = ((Comparable)firstList.get((orderByPair = this.orderByPairs[i]).getIndex())).compareTo(secondList.get(orderByPair.getIndex()))) == 0) continue;
            return orderByPair.isDesc() ? -ret : ret;
        }
        Preconditions.checkNotNull(orderByPair);
        if (firstLen < secondLen) {
            return orderByPair.isDesc() ? 1 : -1;
        }
        if (firstLen > secondLen) {
            return orderByPair.isDesc() ? -1 : 1;
        }
        return 0;
    }
}

