/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.proto.InternalService;
import org.apache.doris.rpc.BackendServiceProxy;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaUtil {
    private static final Logger LOG = LogManager.getLogger(KafkaUtil.class);

    public static List<Integer> getAllKafkaPartitions(String brokerList, String topic, Map<String, String> convertedCustomProperties) throws UserException {
        Object client = null;
        TNetworkAddress address = null;
        boolean ok = false;
        try {
            List<Long> backendIds = Catalog.getCurrentSystemInfo().getBackendIds(true);
            if (backendIds.isEmpty()) {
                throw new LoadException("Failed to get all partitions. No alive backends");
            }
            Collections.shuffle(backendIds);
            Backend be = Catalog.getCurrentSystemInfo().getBackend(backendIds.get(0));
            address = new TNetworkAddress(be.getHost(), be.getBrpcPort());
            InternalService.PProxyRequest request = InternalService.PProxyRequest.newBuilder().setKafkaMetaRequest(InternalService.PKafkaMetaProxyRequest.newBuilder().setKafkaInfo(InternalService.PKafkaLoadInfo.newBuilder().setBrokers(brokerList).setTopic(topic).addAllProperties(convertedCustomProperties.entrySet().stream().map(e -> InternalService.PStringPair.newBuilder().setKey((String)e.getKey()).setVal((String)e.getValue()).build()).collect(Collectors.toList())))).build();
            Future<InternalService.PProxyResult> future = BackendServiceProxy.getInstance().getInfo(address, request);
            InternalService.PProxyResult result = future.get(5L, TimeUnit.SECONDS);
            TStatusCode code = TStatusCode.findByValue((int)result.getStatus().getStatusCode());
            if (code != TStatusCode.OK) {
                throw new UserException("failed to get kafka partition info: " + result.getStatus().getErrorMsgsList());
            }
            List<Integer> list = result.getKafkaMetaResult().getPartitionIdsList();
            if (ok) {
                ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
            } else {
                ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
            }
            return list;
        }
        catch (Exception e2) {
            try {
                LOG.warn("failed to get partitions.", (Throwable)e2);
                throw new LoadException("Failed to get all partitions of kafka topic: " + topic + ". error: " + e2.getMessage());
            }
            catch (Throwable throwable) {
                if (ok) {
                    ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
                }
                throw throwable;
            }
        }
    }

    public static List<Pair<Integer, Long>> getOffsetsForTimes(String brokerList, String topic, Map<String, String> convertedCustomProperties, List<Pair<Integer, Long>> timestampOffsets) throws LoadException {
        Object client = null;
        TNetworkAddress address = null;
        LOG.debug("begin to get offsets for times of topic: {}, {}", (Object)topic, timestampOffsets);
        boolean ok = false;
        try {
            List<Long> backendIds = Catalog.getCurrentSystemInfo().getBackendIds(true);
            if (backendIds.isEmpty()) {
                throw new LoadException("Failed to get offset for times. No alive backends");
            }
            Collections.shuffle(backendIds);
            Backend be = Catalog.getCurrentSystemInfo().getBackend(backendIds.get(0));
            address = new TNetworkAddress(be.getHost(), be.getBrpcPort());
            InternalService.PKafkaMetaProxyRequest.Builder metaRequestBuilder = InternalService.PKafkaMetaProxyRequest.newBuilder().setKafkaInfo(InternalService.PKafkaLoadInfo.newBuilder().setBrokers(brokerList).setTopic(topic).addAllProperties(convertedCustomProperties.entrySet().stream().map(e -> InternalService.PStringPair.newBuilder().setKey((String)e.getKey()).setVal((String)e.getValue()).build()).collect(Collectors.toList())));
            for (Pair<Integer, Long> pair : timestampOffsets) {
                metaRequestBuilder.addOffsetTimes(InternalService.PIntegerPair.newBuilder().setKey((Integer)pair.first).setVal((Long)pair.second).build());
            }
            InternalService.PProxyRequest request = InternalService.PProxyRequest.newBuilder().setKafkaMetaRequest(metaRequestBuilder).build();
            Future<InternalService.PProxyResult> future = BackendServiceProxy.getInstance().getInfo(address, request);
            InternalService.PProxyResult result = future.get(5L, TimeUnit.SECONDS);
            TStatusCode code = TStatusCode.findByValue((int)result.getStatus().getStatusCode());
            if (code != TStatusCode.OK) {
                throw new UserException("failed to get offsets for times: " + result.getStatus().getErrorMsgsList());
            }
            List<InternalService.PIntegerPair> pairs = result.getPartitionOffsets().getOffsetTimesList();
            ArrayList partitionOffsets = Lists.newArrayList();
            for (InternalService.PIntegerPair pair : pairs) {
                partitionOffsets.add(Pair.create(pair.getKey(), pair.getVal()));
            }
            LOG.debug("finish to get offsets for times of topic: {}, {}", (Object)topic, (Object)partitionOffsets);
            ArrayList arrayList = partitionOffsets;
            if (ok) {
                ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
            } else {
                ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
            }
            return arrayList;
        }
        catch (Exception e2) {
            try {
                LOG.warn("failed to get offsets for times.", (Throwable)e2);
                throw new LoadException("Failed to get offsets for times of kafka topic: " + topic + ". error: " + e2.getMessage());
            }
            catch (Throwable throwable) {
                if (ok) {
                    ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
                }
                throw throwable;
            }
        }
    }

    public static List<Pair<Integer, Long>> getLatestOffsets(long jobId, UUID taskId, String brokerList, String topic, Map<String, String> convertedCustomProperties, List<Integer> partitionIds) throws LoadException {
        Object client = null;
        TNetworkAddress address = null;
        LOG.debug("begin to get latest offsets for partitions {} in topic: {}, task {}, job {}", partitionIds, (Object)topic, (Object)taskId, (Object)jobId);
        boolean ok = false;
        try {
            List<Long> backendIds = Catalog.getCurrentSystemInfo().getBackendIds(true);
            if (backendIds.isEmpty()) {
                throw new LoadException("Failed to get latest offsets. No alive backends");
            }
            Collections.shuffle(backendIds);
            Backend be = Catalog.getCurrentSystemInfo().getBackend(backendIds.get(0));
            address = new TNetworkAddress(be.getHost(), be.getBrpcPort());
            InternalService.PKafkaMetaProxyRequest.Builder metaRequestBuilder = InternalService.PKafkaMetaProxyRequest.newBuilder().setKafkaInfo(InternalService.PKafkaLoadInfo.newBuilder().setBrokers(brokerList).setTopic(topic).addAllProperties(convertedCustomProperties.entrySet().stream().map(e -> InternalService.PStringPair.newBuilder().setKey((String)e.getKey()).setVal((String)e.getValue()).build()).collect(Collectors.toList())));
            for (Integer partitionId : partitionIds) {
                metaRequestBuilder.addPartitionIdForLatestOffsets(partitionId);
            }
            InternalService.PProxyRequest request = InternalService.PProxyRequest.newBuilder().setKafkaMetaRequest(metaRequestBuilder).build();
            Future<InternalService.PProxyResult> future = BackendServiceProxy.getInstance().getInfo(address, request);
            InternalService.PProxyResult result = future.get(5L, TimeUnit.SECONDS);
            TStatusCode code = TStatusCode.findByValue((int)result.getStatus().getStatusCode());
            if (code != TStatusCode.OK) {
                throw new UserException("failed to get latest offsets: " + result.getStatus().getErrorMsgsList());
            }
            List<InternalService.PIntegerPair> pairs = result.getPartitionOffsets().getOffsetTimesList();
            ArrayList partitionOffsets = Lists.newArrayList();
            for (InternalService.PIntegerPair pair : pairs) {
                partitionOffsets.add(Pair.create(pair.getKey(), pair.getVal()));
            }
            LOG.debug("finish to get latest offsets for partitions {} in topic: {}, task {}, job {}", (Object)partitionOffsets, (Object)topic, (Object)taskId, (Object)jobId);
            ArrayList arrayList = partitionOffsets;
            if (ok) {
                ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
            } else {
                ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
            }
            return arrayList;
        }
        catch (Exception e2) {
            try {
                LOG.warn("failed to get latest offsets.", (Throwable)e2);
                throw new LoadException("Failed to get latest offsets of kafka topic: " + topic + ". error: " + e2.getMessage());
            }
            catch (Throwable throwable) {
                if (ok) {
                    ClientPool.backendPool.returnObject(address, (BackendService.Client)client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, (BackendService.Client)client);
                }
                throw throwable;
            }
        }
    }
}

