/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.annotations.VisibleForTesting;
import org.apache.doris.common.Config;

public class JdkUtils {
    @VisibleForTesting
    public static boolean checkJavaVersion() {
        if (!Config.check_java_version) {
            return true;
        }
        String javaCompileVersionStr = JdkUtils.getJavaVersionFromFullVersion("openjdk full version \"11.0.15+9-LTS\"");
        String javaRuntimeVersionStr = System.getProperty("java.version");
        int compileVersion = JdkUtils.getJavaVersionAsInteger(javaCompileVersionStr);
        int runtimeVersion = JdkUtils.getJavaVersionAsInteger(javaRuntimeVersionStr);
        if (runtimeVersion < compileVersion) {
            System.out.println("The runtime java version " + javaRuntimeVersionStr + " is less than compile version " + javaCompileVersionStr);
            return false;
        }
        return true;
    }

    public static String getJavaVersionFromFullVersion(String fullVersionStr) {
        int begin = fullVersionStr.indexOf("\"");
        int end = fullVersionStr.lastIndexOf("\"");
        String versionStr = fullVersionStr.substring(begin + 1, end);
        return versionStr;
    }

    public static int getJavaVersionAsInteger(String javaVersionStr) {
        String[] parts = javaVersionStr.split("\\.");
        if (parts[0].equals("1")) {
            return Integer.valueOf(parts[1]);
        }
        return Integer.valueOf(parts[0]);
    }
}

