/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.doris.analysis.TimestampArithmeticExpr;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DynamicPartitionProperty;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.TableProperty;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.common.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicPartitionUtil {
    private static final Logger LOG = LogManager.getLogger(DynamicPartitionUtil.class);
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static void checkTimeUnit(String timeUnit, PartitionInfo partitionInfo) throws DdlException {
        if (Strings.isNullOrEmpty((String)timeUnit) || !timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.DAY.toString()) && !timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString()) && !timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.WEEK.toString()) && !timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.MONTH.toString())) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_TIME_UNIT, timeUnit);
        }
        Preconditions.checkState((boolean)(partitionInfo instanceof RangePartitionInfo));
        RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)partitionInfo;
        Preconditions.checkState((!rangePartitionInfo.isMultiColumnPartition() ? 1 : 0) != 0);
        Column partitionColumn = rangePartitionInfo.getPartitionColumns().get(0);
        if (partitionColumn.getDataType() == PrimitiveType.DATE && timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            ErrorReport.reportDdlException("dynamic_partition.time_unit could not be " + TimestampArithmeticExpr.TimeUnit.HOUR.toString() + " when type of partition column " + partitionColumn.getDisplayName() + " is " + PrimitiveType.DATE.toString(), new Object[0]);
        } else if (PrimitiveType.getIntegerTypes().contains((Object)partitionColumn.getDataType()) && timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            ErrorReport.reportDdlException("dynamic_partition.time_unit could not be " + TimestampArithmeticExpr.TimeUnit.HOUR.toString() + " when type of partition column " + partitionColumn.getDisplayName() + " is Integer", new Object[0]);
        }
    }

    private static void checkPrefix(String prefix) throws DdlException {
        try {
            FeNameFormat.checkPartitionName(prefix);
        }
        catch (AnalysisException e) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_PREFIX, prefix);
        }
    }

    private static int checkStart(String start) throws DdlException {
        try {
            int startInt = Integer.parseInt(start);
            if (startInt >= 0) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_START_ZERO, start);
            }
            return startInt;
        }
        catch (NumberFormatException e) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_START_FORMAT, start);
            return Integer.MIN_VALUE;
        }
    }

    private static int checkEnd(String end) throws DdlException {
        if (Strings.isNullOrEmpty((String)end)) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_END_EMPTY, new Object[0]);
        }
        try {
            int endInt = Integer.parseInt(end);
            if (endInt <= 0) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_END_ZERO, end);
            }
            return endInt;
        }
        catch (NumberFormatException e) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_END_FORMAT, end);
            return Integer.MAX_VALUE;
        }
    }

    private static void checkBuckets(String buckets) throws DdlException {
        if (Strings.isNullOrEmpty((String)buckets)) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_BUCKETS_EMPTY, new Object[0]);
        }
        try {
            if (Integer.parseInt(buckets) <= 0) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_BUCKETS_ZERO, buckets);
            }
        }
        catch (NumberFormatException e) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_BUCKETS_FORMAT, buckets);
        }
    }

    private static void checkEnable(String enable) throws DdlException {
        if (Strings.isNullOrEmpty((String)enable) || !Boolean.TRUE.toString().equalsIgnoreCase(enable) && !Boolean.FALSE.toString().equalsIgnoreCase(enable)) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_ENABLE, enable);
        }
    }

    private static boolean checkCreateHistoryPartition(String create) throws DdlException {
        if (Strings.isNullOrEmpty((String)create) || !Boolean.TRUE.toString().equalsIgnoreCase(create) && !Boolean.FALSE.toString().equalsIgnoreCase(create)) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_CREATE_HISTORY_PARTITION, create);
        }
        return Boolean.valueOf(create);
    }

    private static void checkHistoryPartitionNum(String val) throws DdlException {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new DdlException("Invalid properties: dynamic_partition.history_partition_num");
        }
        try {
            int historyPartitionNum = Integer.parseInt(val);
            if (historyPartitionNum < 0 && historyPartitionNum != -1) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_HISTORY_PARTITION_NUM_ZERO, new Object[0]);
            }
        }
        catch (NumberFormatException e) {
            throw new DdlException("Invalid properties: dynamic_partition.history_partition_num");
        }
    }

    private static void checkStartDayOfMonth(String val) throws DdlException {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new DdlException("Invalid properties: dynamic_partition.start_day_of_month");
        }
        try {
            int dayOfMonth = Integer.parseInt(val);
            if (dayOfMonth < 1 || dayOfMonth > 28) {
                throw new DdlException("dynamic_partition.start_day_of_month should between 1 and 28");
            }
        }
        catch (NumberFormatException e) {
            throw new DdlException("Invalid properties: dynamic_partition.start_day_of_month");
        }
    }

    private static void checkStartDayOfWeek(String val) throws DdlException {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new DdlException("Invalid properties: dynamic_partition.start_day_of_week");
        }
        try {
            int dayOfWeek = Integer.parseInt(val);
            if (dayOfWeek < 1 || dayOfWeek > 7) {
                throw new DdlException("dynamic_partition.start_day_of_week should between 1 and 7");
            }
        }
        catch (NumberFormatException e) {
            throw new DdlException("Invalid properties: dynamic_partition.start_day_of_week");
        }
    }

    private static void checkReplicationNum(String val) throws DdlException {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new DdlException("Invalid properties: dynamic_partition.replication_num");
        }
        try {
            if (Integer.parseInt(val) <= 0) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_REPLICATION_NUM_ZERO, new Object[0]);
            }
        }
        catch (NumberFormatException e) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_REPLICATION_NUM_FORMAT, val);
        }
    }

    private static void checkReplicaAllocation(ReplicaAllocation replicaAlloc) throws DdlException {
        if (replicaAlloc.getTotalReplicaNum() <= 0) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_REPLICATION_NUM_ZERO, new Object[0]);
        }
    }

    private static void checkHotPartitionNum(String val) throws DdlException {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new DdlException("Invalid properties: dynamic_partition.hot_partition_num");
        }
        try {
            if (Integer.parseInt(val) < 0) {
                throw new DdlException("dynamic_partition.hot_partition_num must larger than 0.");
            }
        }
        catch (NumberFormatException e) {
            throw new DdlException("Invalid dynamic_partition.hot_partition_num value");
        }
    }

    public static List<Range> convertStringToPeriodsList(String reservedHistoryPeriods, String timeUnit) throws DdlException {
        ArrayList<Range> reservedHistoryPeriodsToRangeList = new ArrayList<Range>();
        if ("NULL".equals(reservedHistoryPeriods)) {
            return reservedHistoryPeriodsToRangeList;
        }
        Pattern pattern = DynamicPartitionUtil.getPattern(timeUnit);
        Matcher matcher = pattern.matcher(reservedHistoryPeriods);
        while (matcher.find()) {
            String upperBorderOfReservedHistory;
            String lowerBorderOfReservedHistory = matcher.group(1);
            if (lowerBorderOfReservedHistory.compareTo(upperBorderOfReservedHistory = matcher.group(2)) > 0) {
                ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_RESERVED_HISTORY_PERIODS_START_LARGER_THAN_ENDS, lowerBorderOfReservedHistory, upperBorderOfReservedHistory);
                continue;
            }
            reservedHistoryPeriodsToRangeList.add(Range.closed((Comparable)((Object)lowerBorderOfReservedHistory), (Comparable)((Object)upperBorderOfReservedHistory)));
        }
        return reservedHistoryPeriodsToRangeList;
    }

    private static Pattern getPattern(String timeUnit) {
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            return Pattern.compile("\\[([0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}),([0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2})\\]");
        }
        return Pattern.compile("\\[([0-9]{4}-[0-9]{2}-[0-9]{2}),([0-9]{4}-[0-9]{2}-[0-9]{2})\\]");
    }

    public static String sortedListedToString(String reservedHistoryPeriods, String timeUnit) throws DdlException {
        if ("NULL".equals(reservedHistoryPeriods)) {
            return reservedHistoryPeriods;
        }
        List<Range> reservedHistoryPeriodsToRangeList = DynamicPartitionUtil.convertStringToPeriodsList(reservedHistoryPeriods, timeUnit);
        reservedHistoryPeriodsToRangeList.sort(new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return o1.lowerEndpoint().compareTo(o2.lowerEndpoint());
            }
        });
        List sortedReservedHistoryPeriods = reservedHistoryPeriodsToRangeList.stream().map(e -> "[" + e.lowerEndpoint() + "," + e.upperEndpoint() + "]").collect(Collectors.toList());
        return String.join((CharSequence)",", sortedReservedHistoryPeriods);
    }

    private static void checkReservedHistoryPeriodValidate(String reservedHistoryPeriods, String timeUnit) throws DdlException {
        if (Strings.isNullOrEmpty((String)reservedHistoryPeriods)) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_RESERVED_HISTORY_PERIODS_EMPTY, new Object[0]);
        }
        if ("NULL".equals(reservedHistoryPeriods)) {
            return;
        }
        if (!reservedHistoryPeriods.startsWith("[") || !reservedHistoryPeriods.endsWith("]")) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_RESERVED_HISTORY_PERIODS_INVALID, "dynamic_partition.reserved_history_periods", reservedHistoryPeriods);
        }
        List<Range> reservedHistoryPeriodsToRangeList = DynamicPartitionUtil.convertStringToPeriodsList(reservedHistoryPeriods, timeUnit);
        Integer sizeOfPeriods = reservedHistoryPeriods.split("],\\[").length;
        SimpleDateFormat sdf = DynamicPartitionUtil.getSimpleDateFormat(timeUnit);
        if (reservedHistoryPeriodsToRangeList.size() != sizeOfPeriods.intValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERROR_DYNAMIC_PARTITION_RESERVED_HISTORY_PERIODS_INVALID, "dynamic_partition.reserved_history_periods", reservedHistoryPeriods);
        } else {
            try {
                for (Range range : reservedHistoryPeriodsToRangeList) {
                    String formattedLowerBound = sdf.format(sdf.parse(range.lowerEndpoint().toString()));
                    String formattedUpperBound = sdf.format(sdf.parse(range.upperEndpoint().toString()));
                    if (range.lowerEndpoint().toString().equals(formattedLowerBound) && range.upperEndpoint().toString().equals(formattedUpperBound)) continue;
                    throw new DdlException("Invalid dynamic_partition.reserved_history_periods value. It must be correct DATE value \"[yyyy-MM-dd,yyyy-MM-dd],[...,...]\" while time_unit is DAY/WEEK/MONTH or \"[yyyy-MM-dd HH:mm:ss,yyyy-MM-dd HH:mm:ss],[...,...]\" while time_unit is HOUR.");
                }
            }
            catch (ParseException e) {
                throw new DdlException("Invalid dynamic_partition.reserved_history_periods value. It must be like \"[yyyy-MM-dd,yyyy-MM-dd],[...,...]\" while time_unit is DAY/WEEK/MONTH or \"[yyyy-MM-dd HH:mm:ss,yyyy-MM-dd HH:mm:ss],[...,...]\" while time_unit is HOUR.");
            }
        }
    }

    private static SimpleDateFormat getSimpleDateFormat(String timeUnit) {
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            return new SimpleDateFormat(DATETIME_FORMAT);
        }
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static boolean checkDynamicPartitionPropertiesExist(Map<String, String> properties) {
        if (properties == null) {
            return false;
        }
        for (String key : properties.keySet()) {
            if (!key.startsWith("dynamic_partition.")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkInputDynamicPartitionProperties(Map<String, String> properties, PartitionInfo partitionInfo) throws DdlException {
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        if (partitionInfo.getType() != PartitionType.RANGE || partitionInfo.isMultiColumnPartition()) {
            throw new DdlException("Dynamic partition only support single-column range partition");
        }
        String timeUnit = properties.get("dynamic_partition.time_unit");
        String prefix = properties.get("dynamic_partition.prefix");
        String start = properties.get("dynamic_partition.start");
        String timeZone = properties.get("dynamic_partition.time_zone");
        String end = properties.get("dynamic_partition.end");
        String buckets = properties.get("dynamic_partition.buckets");
        String enable = properties.get("dynamic_partition.enable");
        String createHistoryPartition = properties.get("dynamic_partition.create_history_partition");
        String historyPartitionNum = properties.get("dynamic_partition.history_partition_num");
        String reservedHistoryPeriods = properties.get("dynamic_partition.reserved_history_periods");
        if (!(Strings.isNullOrEmpty((String)enable) && Strings.isNullOrEmpty((String)timeUnit) && Strings.isNullOrEmpty((String)timeZone) && Strings.isNullOrEmpty((String)prefix) && Strings.isNullOrEmpty((String)start) && Strings.isNullOrEmpty((String)end) && Strings.isNullOrEmpty((String)buckets) && Strings.isNullOrEmpty((String)createHistoryPartition) && Strings.isNullOrEmpty((String)historyPartitionNum) && Strings.isNullOrEmpty((String)reservedHistoryPeriods))) {
            if (Strings.isNullOrEmpty((String)enable)) {
                properties.put("dynamic_partition.enable", "true");
            }
            if (Strings.isNullOrEmpty((String)timeUnit)) {
                throw new DdlException("Must assign dynamic_partition.time_unit properties");
            }
            if (Strings.isNullOrEmpty((String)prefix)) {
                throw new DdlException("Must assign dynamic_partition.prefix properties");
            }
            if (Strings.isNullOrEmpty((String)start)) {
                properties.put("dynamic_partition.start", String.valueOf(Integer.MIN_VALUE));
            }
            if (Strings.isNullOrEmpty((String)end)) {
                throw new DdlException("Must assign dynamic_partition.end properties");
            }
            if (Strings.isNullOrEmpty((String)buckets)) {
                throw new DdlException("Must assign dynamic_partition.buckets properties");
            }
            if (Strings.isNullOrEmpty((String)timeZone)) {
                properties.put("dynamic_partition.time_zone", TimeUtils.getSystemTimeZone().getID());
            }
            if (Strings.isNullOrEmpty((String)createHistoryPartition)) {
                properties.put("dynamic_partition.create_history_partition", "false");
            }
            if (Strings.isNullOrEmpty((String)historyPartitionNum)) {
                properties.put("dynamic_partition.history_partition_num", String.valueOf(-1));
            }
            if (Strings.isNullOrEmpty((String)reservedHistoryPeriods)) {
                properties.put("dynamic_partition.reserved_history_periods", String.valueOf("NULL"));
            }
        }
        return true;
    }

    public static void registerOrRemoveDynamicPartitionTable(long dbId, OlapTable olapTable, boolean isReplay) {
        if (olapTable.getTableProperty() != null && olapTable.getTableProperty().getDynamicPartitionProperty() != null) {
            if (olapTable.getTableProperty().getDynamicPartitionProperty().getEnable()) {
                if (!isReplay) {
                    Catalog.getCurrentCatalog().getDynamicPartitionScheduler().executeDynamicPartitionFirstTime(dbId, olapTable.getId());
                }
                Catalog.getCurrentCatalog().getDynamicPartitionScheduler().registerDynamicPartitionTable(dbId, olapTable.getId());
            } else {
                Catalog.getCurrentCatalog().getDynamicPartitionScheduler().removeDynamicPartitionTable(dbId, olapTable.getId());
            }
        }
    }

    public static Map<String, String> analyzeDynamicPartition(Map<String, String> properties, PartitionInfo partitionInfo) throws UserException {
        String val;
        HashMap<String, String> analyzedProperties = new HashMap<String, String>();
        if (properties.containsKey("dynamic_partition.time_unit")) {
            String timeUnitValue = properties.get("dynamic_partition.time_unit");
            DynamicPartitionUtil.checkTimeUnit(timeUnitValue, partitionInfo);
            properties.remove("dynamic_partition.time_unit");
            analyzedProperties.put("dynamic_partition.time_unit", timeUnitValue);
        }
        if (properties.containsKey("dynamic_partition.prefix")) {
            String prefixValue = properties.get("dynamic_partition.prefix");
            DynamicPartitionUtil.checkPrefix(prefixValue);
            properties.remove("dynamic_partition.prefix");
            analyzedProperties.put("dynamic_partition.prefix", prefixValue);
        }
        if (properties.containsKey("dynamic_partition.buckets")) {
            String bucketsValue = properties.get("dynamic_partition.buckets");
            DynamicPartitionUtil.checkBuckets(bucketsValue);
            properties.remove("dynamic_partition.buckets");
            analyzedProperties.put("dynamic_partition.buckets", bucketsValue);
        }
        if (properties.containsKey("dynamic_partition.enable")) {
            String enableValue = properties.get("dynamic_partition.enable");
            DynamicPartitionUtil.checkEnable(enableValue);
            properties.remove("dynamic_partition.enable");
            analyzedProperties.put("dynamic_partition.enable", enableValue);
        }
        int start = Integer.MIN_VALUE;
        if (properties.containsKey("dynamic_partition.start")) {
            String startValue = properties.get("dynamic_partition.start");
            start = DynamicPartitionUtil.checkStart(startValue);
            properties.remove("dynamic_partition.start");
            analyzedProperties.put("dynamic_partition.start", startValue);
        }
        int end = Integer.MAX_VALUE;
        boolean hasEnd = false;
        if (properties.containsKey("dynamic_partition.end")) {
            String endValue = properties.get("dynamic_partition.end");
            end = DynamicPartitionUtil.checkEnd(endValue);
            properties.remove("dynamic_partition.end");
            analyzedProperties.put("dynamic_partition.end", endValue);
            hasEnd = true;
        }
        boolean createHistoryPartition = false;
        if (properties.containsKey("dynamic_partition.create_history_partition")) {
            val = properties.get("dynamic_partition.create_history_partition");
            createHistoryPartition = DynamicPartitionUtil.checkCreateHistoryPartition(val);
            properties.remove("dynamic_partition.create_history_partition");
            analyzedProperties.put("dynamic_partition.create_history_partition", val);
        }
        if (properties.containsKey("dynamic_partition.history_partition_num")) {
            val = properties.get("dynamic_partition.history_partition_num");
            DynamicPartitionUtil.checkHistoryPartitionNum(val);
            properties.remove("dynamic_partition.history_partition_num");
            analyzedProperties.put("dynamic_partition.history_partition_num", val);
        }
        int expectCreatePartitionNum = 0;
        if (!createHistoryPartition) {
            start = 0;
            expectCreatePartitionNum = end - start;
        } else {
            int historyPartitionNum = Integer.valueOf(analyzedProperties.getOrDefault("dynamic_partition.history_partition_num", String.valueOf(-1)));
            if (historyPartitionNum != -1) {
                expectCreatePartitionNum = end - Math.max(start, -historyPartitionNum);
            } else {
                if (start == Integer.MIN_VALUE) {
                    throw new DdlException("Provide start or history_partition_num property when creating history partition");
                }
                expectCreatePartitionNum = end - start;
            }
        }
        if (hasEnd && expectCreatePartitionNum > Config.max_dynamic_partition_num) {
            throw new DdlException("Too many dynamic partitions: " + expectCreatePartitionNum + ". Limit: " + Config.max_dynamic_partition_num);
        }
        if (properties.containsKey("dynamic_partition.start_day_of_month")) {
            String val2 = properties.get("dynamic_partition.start_day_of_month");
            DynamicPartitionUtil.checkStartDayOfMonth(val2);
            properties.remove("dynamic_partition.start_day_of_month");
            analyzedProperties.put("dynamic_partition.start_day_of_month", val2);
        }
        if (properties.containsKey("dynamic_partition.start_day_of_week")) {
            String val3 = properties.get("dynamic_partition.start_day_of_week");
            DynamicPartitionUtil.checkStartDayOfWeek(val3);
            properties.remove("dynamic_partition.start_day_of_week");
            analyzedProperties.put("dynamic_partition.start_day_of_week", val3);
        }
        if (properties.containsKey("dynamic_partition.time_zone")) {
            String val4 = properties.get("dynamic_partition.time_zone");
            TimeUtils.checkTimeZoneValidAndStandardize(val4);
            properties.remove("dynamic_partition.time_zone");
            analyzedProperties.put("dynamic_partition.time_zone", val4);
        }
        if (properties.containsKey("dynamic_partition.replication_num")) {
            String val5 = properties.get("dynamic_partition.replication_num");
            DynamicPartitionUtil.checkReplicationNum(val5);
            properties.remove("dynamic_partition.replication_num");
            analyzedProperties.put("dynamic_partition.replication_allocation", new ReplicaAllocation(Short.valueOf(val5)).toCreateStmt());
        }
        if (properties.containsKey("dynamic_partition.replication_allocation")) {
            ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(properties, "dynamic_partition");
            DynamicPartitionUtil.checkReplicaAllocation(replicaAlloc);
            properties.remove("dynamic_partition.replication_allocation");
            analyzedProperties.put("dynamic_partition.replication_allocation", replicaAlloc.toCreateStmt());
        }
        if (properties.containsKey("dynamic_partition.hot_partition_num")) {
            String val6 = properties.get("dynamic_partition.hot_partition_num");
            DynamicPartitionUtil.checkHotPartitionNum(val6);
            properties.remove("dynamic_partition.hot_partition_num");
            analyzedProperties.put("dynamic_partition.hot_partition_num", val6);
        }
        if (properties.containsKey("dynamic_partition.reserved_history_periods")) {
            String reservedHistoryPeriods = properties.get("dynamic_partition.reserved_history_periods");
            DynamicPartitionUtil.checkReservedHistoryPeriodValidate(reservedHistoryPeriods, (String)analyzedProperties.get("dynamic_partition.time_unit"));
            properties.remove("dynamic_partition.reserved_history_periods");
            analyzedProperties.put("dynamic_partition.reserved_history_periods", reservedHistoryPeriods);
        }
        return analyzedProperties;
    }

    public static void checkAlterAllowed(OlapTable olapTable) throws DdlException {
        TableProperty tableProperty = olapTable.getTableProperty();
        if (tableProperty != null && tableProperty.getDynamicPartitionProperty() != null && tableProperty.getDynamicPartitionProperty().isExist() && tableProperty.getDynamicPartitionProperty().getEnable()) {
            throw new DdlException("Cannot add/drop partition on a Dynamic Partition Table, Use command `ALTER TABLE tbl_name SET (\"dynamic_partition.enable\" = \"false\")` firstly.");
        }
    }

    public static boolean isDynamicPartitionTable(Table table) {
        if (!(table instanceof OlapTable) || !((OlapTable)table).getPartitionInfo().getType().equals((Object)PartitionType.RANGE)) {
            return false;
        }
        RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)((OlapTable)table).getPartitionInfo();
        TableProperty tableProperty = ((OlapTable)table).getTableProperty();
        if (tableProperty == null || !tableProperty.getDynamicPartitionProperty().isExist()) {
            return false;
        }
        return rangePartitionInfo.getPartitionColumns().size() == 1 && tableProperty.getDynamicPartitionProperty().getEnable();
    }

    public static void checkAndSetDynamicPartitionProperty(OlapTable olapTable, Map<String, String> properties) throws UserException {
        if (DynamicPartitionUtil.checkInputDynamicPartitionProperties(properties, olapTable.getPartitionInfo())) {
            Map<String, String> dynamicPartitionProperties = DynamicPartitionUtil.analyzeDynamicPartition(properties, olapTable.getPartitionInfo());
            TableProperty tableProperty = olapTable.getTableProperty();
            if (tableProperty != null) {
                tableProperty.modifyTableProperties(dynamicPartitionProperties);
                tableProperty.buildDynamicProperty();
            } else {
                olapTable.setTableProperty(new TableProperty(dynamicPartitionProperties).buildDynamicProperty());
            }
        }
    }

    public static String getPartitionFormat(Column column) throws DdlException {
        if (column.getDataType().equals((Object)PrimitiveType.DATE)) {
            return DATE_FORMAT;
        }
        if (column.getDataType().equals((Object)PrimitiveType.DATETIME)) {
            return DATETIME_FORMAT;
        }
        if (PrimitiveType.getIntegerTypes().contains((Object)column.getDataType())) {
            return TIMESTAMP_FORMAT;
        }
        throw new DdlException("Dynamic Partition Only Support DATE, DATETIME and INTEGER Type Now.");
    }

    public static String getFormattedPartitionName(TimeZone tz, String formattedDateStr, String timeUnit) {
        formattedDateStr = formattedDateStr.replace("-", "").replace(":", "").replace(" ", "");
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.DAY.toString())) {
            return formattedDateStr.substring(0, 8);
        }
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.MONTH.toString())) {
            return formattedDateStr.substring(0, 6);
        }
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            return formattedDateStr.substring(0, 10);
        }
        formattedDateStr = formattedDateStr.substring(0, 8);
        Calendar calendar = Calendar.getInstance(tz);
        try {
            calendar.setTime(new SimpleDateFormat(TIMESTAMP_FORMAT).parse(formattedDateStr));
        }
        catch (ParseException e) {
            LOG.warn("Format dynamic partition name error. Error={}", (Object)e.getMessage());
            return formattedDateStr;
        }
        int weekOfYear = calendar.get(3);
        if (weekOfYear <= 1 && calendar.get(2) >= 11) {
            weekOfYear += 52;
        }
        return String.format("%s_%02d", calendar.get(1), weekOfYear);
    }

    public static String getPartitionRangeString(DynamicPartitionProperty property, ZonedDateTime current, int offset, String format) {
        String timeUnit = property.getTimeUnit();
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.DAY.toString())) {
            return DynamicPartitionUtil.getPartitionRangeOfDay(current, offset, format);
        }
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.WEEK.toString())) {
            return DynamicPartitionUtil.getPartitionRangeOfWeek(current, offset, property.getStartOfWeek(), format);
        }
        if (timeUnit.equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.HOUR.toString())) {
            return DynamicPartitionUtil.getPartitionRangeOfHour(current, offset, format);
        }
        return DynamicPartitionUtil.getPartitionRangeOfMonth(current, offset, property.getStartOfMonth(), format);
    }

    public static String getHistoryPartitionRangeString(DynamicPartitionProperty dynamicPartitionProperty, String time, String format) {
        ZoneId zoneId = dynamicPartitionProperty.getTimeZone().toZoneId();
        Date date = null;
        Timestamp timestamp = null;
        String timeUnit = dynamicPartitionProperty.getTimeUnit();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.s").withZone(zoneId);
        SimpleDateFormat simpleDateFormat = DynamicPartitionUtil.getSimpleDateFormat(timeUnit);
        try {
            date = simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            LOG.warn("Parse dynamic partition periods error. Error={}", (Object)e.getMessage());
            return DynamicPartitionUtil.getFormattedTimeWithoutMinuteSecond(ZonedDateTime.parse(timestamp.toString(), dateTimeFormatter), format);
        }
        timestamp = new Timestamp(date.getTime());
        return DynamicPartitionUtil.getFormattedTimeWithoutMinuteSecond(ZonedDateTime.parse(timestamp.toString(), dateTimeFormatter), format);
    }

    public static String getPartitionRangeOfHour(ZonedDateTime current, int offset, String format) {
        return DynamicPartitionUtil.getFormattedTimeWithoutMinuteSecond(current.plusHours(offset), format);
    }

    private static String getPartitionRangeOfDay(ZonedDateTime current, int offset, String format) {
        return DynamicPartitionUtil.getFormattedTimeWithoutHourMinuteSecond(current.plusDays(offset), format);
    }

    private static String getPartitionRangeOfWeek(ZonedDateTime current, int offset, StartOfDate startOf, String format) {
        Preconditions.checkArgument((boolean)startOf.isStartOfWeek());
        ZonedDateTime offsetWeek = current.plusWeeks(offset);
        int day = offsetWeek.getDayOfWeek().getValue();
        ZonedDateTime resultTime = offsetWeek.plusDays(startOf.dayOfWeek - day);
        return DynamicPartitionUtil.getFormattedTimeWithoutHourMinuteSecond(resultTime, format);
    }

    private static String getPartitionRangeOfMonth(ZonedDateTime current, int offset, StartOfDate startOf, String format) {
        Preconditions.checkArgument((boolean)startOf.isStartOfMonth());
        int realOffset = offset;
        int currentDay = current.getDayOfMonth();
        if (currentDay < startOf.day) {
            --realOffset;
        }
        ZonedDateTime resultTime = current.plusMonths(realOffset).withDayOfMonth(startOf.day);
        return DynamicPartitionUtil.getFormattedTimeWithoutHourMinuteSecond(resultTime, format);
    }

    private static String getFormattedTimeWithoutHourMinuteSecond(ZonedDateTime zonedDateTime, String format) {
        ZonedDateTime timeWithoutHourMinuteSecond = zonedDateTime.withHour(0).withMinute(0).withSecond(0);
        return DateTimeFormatter.ofPattern(format).format(timeWithoutHourMinuteSecond);
    }

    private static String getFormattedTimeWithoutMinuteSecond(ZonedDateTime zonedDateTime, String format) {
        ZonedDateTime timeWithoutMinuteSecond = zonedDateTime.withMinute(0).withSecond(0);
        return DateTimeFormatter.ofPattern(format).format(timeWithoutMinuteSecond);
    }

    public static class StartOfDate {
        public int month;
        public int day;
        public int dayOfWeek;

        public StartOfDate(int month, int day, int dayOfWeek) {
            this.month = month;
            this.day = day;
            this.dayOfWeek = dayOfWeek;
        }

        public boolean isStartOfYear() {
            return this.month != -1 && this.day != -1 && this.dayOfWeek == -1;
        }

        public boolean isStartOfMonth() {
            return this.month == -1 && this.day != -1 && this.dayOfWeek == -1;
        }

        public boolean isStartOfWeek() {
            return this.month == -1 && this.day == -1 && this.dayOfWeek != -1;
        }

        public String toDisplayInfo() {
            if (this.isStartOfWeek()) {
                return DayOfWeek.of(this.dayOfWeek).name();
            }
            if (this.isStartOfMonth()) {
                return Util.ordinal(this.day);
            }
            if (this.isStartOfYear()) {
                return Month.of(this.month) + " " + Util.ordinal(this.day);
            }
            return FeConstants.null_string;
        }

        public String toString() {
            return super.toString();
        }
    }
}

