/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class DigitalVersion
implements Comparable<DigitalVersion> {
    public static final DigitalVersion CURRENT_DORIS_VERSION = new DigitalVersion(110000);
    public static final DigitalVersion CURRENT_PLUGIN_VERSION = new DigitalVersion(110000);
    public static final DigitalVersion JDK_9_0_0 = new DigitalVersion(9000000);
    public static final DigitalVersion JDK_1_8_0 = new DigitalVersion(1080000);
    @SerializedName(value="id")
    public final int id;
    @SerializedName(value="major")
    public final byte major;
    @SerializedName(value="minor")
    public final byte minor;
    @SerializedName(value="revision")
    public final byte revision;

    public DigitalVersion(int id) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
    }

    public DigitalVersion(byte major, byte minor, byte revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.id = major * 1000000 + minor * 10000 + revision * 100;
    }

    public static DigitalVersion fromString(String version) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)version)) {
            throw new IllegalArgumentException("Illegal empty version");
        }
        String[] list = version.split("[.]");
        if (list.length < 3) {
            throw new IllegalArgumentException("Illegal version format: " + version);
        }
        try {
            int major = Integer.parseInt(list[0].trim());
            int minor = Integer.parseInt(list[1].trim());
            int revision = Integer.parseInt(list[2].trim());
            if (major >= 100 || minor >= 100 || revision >= 100) {
                throw new IllegalArgumentException("Illegal version format: " + version);
            }
            return new DigitalVersion((byte)major, (byte)minor, (byte)revision);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal version format: " + version, e);
        }
    }

    @Override
    public int compareTo(DigitalVersion o) {
        return Integer.compare(this.id, o.id);
    }

    public boolean onOrAfter(DigitalVersion v) {
        return this.id >= v.id;
    }

    public boolean after(DigitalVersion v) {
        return this.id > v.id;
    }

    public boolean before(DigitalVersion v) {
        return this.id < v.id;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalVersion version = (DigitalVersion)o;
        return this.id == version.id && this.major == version.major && this.minor == version.minor && this.revision == version.revision;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.major, this.minor, this.revision);
    }
}

