/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.UUID;
import org.apache.doris.common.Pair;
import org.apache.doris.proto.Types;
import org.apache.doris.thrift.TUniqueId;

public class DebugUtil {
    public static final DecimalFormat DECIMAL_FORMAT_SCALE_3 = new DecimalFormat("0.000");
    public static int THOUSAND = 1000;
    public static int MILLION = 1000 * THOUSAND;
    public static int BILLION = 1000 * MILLION;
    public static int SECOND = 1000;
    public static int MINUTE = 60 * SECOND;
    public static int HOUR = 60 * MINUTE;
    public static long KILOBYTE = 1024L;
    public static long MEGABYTE = 1024L * KILOBYTE;
    public static long GIGABYTE = 1024L * MEGABYTE;
    public static long TERABYTE = 1024L * GIGABYTE;

    public static Pair<Double, String> getUint(long value) {
        Double doubleValue = value;
        String unit = "";
        if (value >= (long)BILLION) {
            unit = "B";
            doubleValue = doubleValue / (double)BILLION;
        } else if (value >= (long)MILLION) {
            unit = "M";
            doubleValue = doubleValue / (double)MILLION;
        } else if (value >= (long)THOUSAND) {
            unit = "K";
            doubleValue = doubleValue / (double)THOUSAND;
        }
        Pair<Double, String> returnValue = Pair.create(doubleValue, unit);
        return returnValue;
    }

    public static void printTimeMs(long value, StringBuilder builder) {
        long newValue = value;
        if (newValue == 0L) {
            builder.append("0");
        } else {
            boolean hour = false;
            boolean minute = false;
            if (newValue >= (long)HOUR) {
                builder.append(newValue / (long)HOUR).append("h");
                newValue %= (long)HOUR;
                hour = true;
            }
            if (newValue >= (long)MINUTE) {
                builder.append(newValue / (long)MINUTE).append("m");
                newValue %= (long)MINUTE;
                minute = true;
            }
            if (!hour && newValue >= (long)SECOND) {
                builder.append(newValue / (long)SECOND).append("s");
                newValue %= (long)SECOND;
            }
            if (!hour && !minute) {
                builder.append(newValue).append("ms");
            }
        }
    }

    public static String getPrettyStringMs(long timestampMs) {
        StringBuilder builder = new StringBuilder();
        DebugUtil.printTimeMs(timestampMs, builder);
        return builder.toString();
    }

    public static Pair<Double, String> getByteUint(long value) {
        Double doubleValue = value;
        String unit = "";
        if (value == 0L) {
            unit = "";
        } else if (value > TERABYTE) {
            unit = "TB";
            doubleValue = doubleValue / (double)TERABYTE;
        } else if (value > GIGABYTE) {
            unit = "GB";
            doubleValue = doubleValue / (double)GIGABYTE;
        } else if (value > MEGABYTE) {
            unit = "MB";
            doubleValue = doubleValue / (double)MEGABYTE;
        } else if (value > KILOBYTE) {
            unit = "KB";
            doubleValue = doubleValue / (double)KILOBYTE;
        } else {
            unit = "B";
        }
        Pair<Double, String> returnValue = Pair.create(doubleValue, unit);
        return returnValue;
    }

    public static String printByteWithUnit(long value) {
        Pair<Double, String> quotaUnitPair = DebugUtil.getByteUint(value);
        String readableQuota = DECIMAL_FORMAT_SCALE_3.format(quotaUnitPair.first) + " " + (String)quotaUnitPair.second;
        return readableQuota;
    }

    public static String printId(TUniqueId id) {
        if (id == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toHexString(id.hi)).append("-").append(Long.toHexString(id.lo));
        return builder.toString();
    }

    public static String printId(UUID id) {
        TUniqueId tUniqueId = new TUniqueId(id.getMostSignificantBits(), id.getLeastSignificantBits());
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toHexString(tUniqueId.hi)).append("-").append(Long.toHexString(tUniqueId.lo));
        return builder.toString();
    }

    public static String printId(Types.PUniqueId id) {
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toHexString(id.getHi())).append("-").append(Long.toHexString(id.getLo()));
        return builder.toString();
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

