/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.doris.meta.MetaContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Daemon
extends Thread {
    private static final Logger LOG = LogManager.getLogger(Daemon.class);
    private static final int DEFAULT_INTERVAL_SECONDS = 30;
    private long intervalMs;
    private AtomicBoolean isStop;
    private Runnable runnable;
    private AtomicBoolean isStart = new AtomicBoolean(false);
    private MetaContext metaContext = null;

    public Daemon() {
        this.setDaemon(true);
        this.intervalMs = 30000L;
        this.isStop = new AtomicBoolean(false);
    }

    public Daemon(Runnable runnable) {
        super(runnable);
        this.setDaemon(true);
        this.runnable = runnable;
        this.setName(runnable.toString());
    }

    public Daemon(ThreadGroup group, Runnable runnable) {
        super(group, runnable);
        this.setDaemon(true);
        this.runnable = runnable;
        this.setName(runnable.toString());
    }

    public Daemon(String name) {
        this(name, 30000L);
    }

    public Daemon(String name, long intervalMs) {
        this(intervalMs);
        this.setName(name);
    }

    public Daemon(long intervalMs) {
        this();
        this.intervalMs = intervalMs;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public synchronized void start() {
        if (this.isStart.compareAndSet(false, true)) {
            super.start();
        }
    }

    public void setMetaContext(MetaContext metaContext) {
        this.metaContext = metaContext;
    }

    public void exit() {
        this.isStop.set(true);
    }

    public long getInterval() {
        return this.intervalMs;
    }

    public void setInterval(long intervalMs) {
        this.intervalMs = intervalMs;
    }

    protected void runOneCycle() {
    }

    @Override
    public void run() {
        if (this.metaContext != null) {
            this.metaContext.setThreadLocalInfo();
        }
        while (!this.isStop.get()) {
            try {
                this.runOneCycle();
            }
            catch (Throwable e) {
                LOG.error("daemon thread got exception. name: {}", (Object)this.getName(), (Object)e);
            }
            try {
                Thread.sleep(this.intervalMs);
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException: ", (Throwable)e);
            }
        }
        if (this.metaContext != null) {
            MetaContext.remove();
        }
        LOG.error("daemon thread exits. name=" + this.getName());
    }
}

