/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.util;

import java.io.IOException;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TBrokerCloseReaderRequest;
import org.apache.doris.thrift.TBrokerFD;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TBrokerListPathRequest;
import org.apache.doris.thrift.TBrokerListResponse;
import org.apache.doris.thrift.TBrokerOpenReaderRequest;
import org.apache.doris.thrift.TBrokerOpenReaderResponse;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.doris.thrift.TBrokerPReadRequest;
import org.apache.doris.thrift.TBrokerReadResponse;
import org.apache.doris.thrift.TBrokerVersion;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class BrokerReader {
    private static final Logger LOG = LogManager.getLogger(BrokerReader.class);
    private BrokerDesc brokerDesc;
    private TNetworkAddress address;
    private TPaloBrokerService.Client client;
    private long currentPos;

    public static BrokerReader create(BrokerDesc brokerDesc) throws IOException {
        try {
            TNetworkAddress address = BrokerUtil.getAddress(brokerDesc);
            return new BrokerReader(address, BrokerUtil.borrowClient(address), brokerDesc);
        }
        catch (UserException e) {
            throw new IOException(e);
        }
    }

    public static BrokerReader create(BrokerDesc brokerDesc, String ip, int port) throws IOException {
        try {
            TNetworkAddress address = new TNetworkAddress(ip, port);
            return new BrokerReader(address, BrokerUtil.borrowClient(address), brokerDesc);
        }
        catch (UserException e) {
            throw new IOException(e);
        }
    }

    private BrokerReader(TNetworkAddress address, TPaloBrokerService.Client client, BrokerDesc brokerDesc) {
        this.brokerDesc = brokerDesc;
        this.address = address;
        this.client = client;
    }

    public long getCurrentPos() {
        return this.currentPos;
    }

    public byte[] pread(TBrokerFD fd, long offset, int length) throws IOException, EOFException {
        TBrokerPReadRequest tPReadRequest = new TBrokerPReadRequest(TBrokerVersion.VERSION_ONE, fd, offset, (long)length);
        TBrokerReadResponse tReadResponse = null;
        try {
            tReadResponse = this.client.pread(tPReadRequest);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        if (tReadResponse.getOpStatus().getStatusCode() != TBrokerOperationStatusCode.OK) {
            throw new IOException("Broker pread failed. fd=" + fd.toString() + ", broker=" + this.client + ", msg=" + tReadResponse.getOpStatus().getMessage());
        }
        if (tReadResponse.getOpStatus().getStatusCode() == TBrokerOperationStatusCode.END_OF_FILE) {
            throw new EOFException();
        }
        return tReadResponse.getData();
    }

    public TBrokerFD open(String path) throws IOException {
        String clientId = FrontendOptions.getLocalHostAddress() + ":" + Config.rpc_port;
        TBrokerOpenReaderRequest tOpenReaderRequest = new TBrokerOpenReaderRequest(TBrokerVersion.VERSION_ONE, path, 0L, clientId, this.brokerDesc.getProperties());
        TBrokerOpenReaderResponse tOpenReaderResponse = null;
        try {
            tOpenReaderResponse = this.client.openReader(tOpenReaderRequest);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        if (tOpenReaderResponse.getOpStatus().getStatusCode() != TBrokerOperationStatusCode.OK) {
            throw new IOException("Broker open reader failed. path=" + path + ", broker=" + this.address + ", msg=" + tOpenReaderResponse.getOpStatus().getMessage());
        }
        this.currentPos = 0L;
        return tOpenReaderResponse.getFd();
    }

    public void close(TBrokerFD fd) {
        TBrokerCloseReaderRequest tCloseReaderRequest = new TBrokerCloseReaderRequest(TBrokerVersion.VERSION_ONE, fd);
        TBrokerOperationStatus tOperationStatus = null;
        try {
            tOperationStatus = this.client.closeReader(tCloseReaderRequest);
        }
        catch (TException e) {
            LOG.warn("Broker close reader failed. fd={}, address={}", (Object)fd.toString(), (Object)this.address, (Object)e);
        }
        if (tOperationStatus == null || tOperationStatus.getStatusCode() != TBrokerOperationStatusCode.OK) {
            LOG.warn("Broker close reader failed. fd={}, address={}, error={}", (Object)fd.toString(), (Object)this.address, (Object)tOperationStatus.getMessage());
        }
    }

    public long getFileLength(String path) throws IOException {
        TBrokerListPathRequest request = new TBrokerListPathRequest(TBrokerVersion.VERSION_ONE, path, false, this.brokerDesc.getProperties());
        TBrokerListResponse tBrokerListResponse = null;
        try {
            tBrokerListResponse = this.client.listPath(request);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        if (tBrokerListResponse.getOpStatus().getStatusCode() != TBrokerOperationStatusCode.OK) {
            throw new IOException("Broker list path failed. path=" + path + ",broker=" + this.address + ",msg=" + tBrokerListResponse.getOpStatus().getMessage());
        }
        if (tBrokerListResponse.files.size() != 1) {
            throw new IOException("Match " + tBrokerListResponse.files.size() + " files. Expected: 1");
        }
        TBrokerFileStatus fileStatus = (TBrokerFileStatus)tBrokerListResponse.files.get(0);
        if (fileStatus.isDir) {
            throw new IOException("Meet dir. Expect file");
        }
        return fileStatus.size;
    }

    public static class EOFException
    extends Exception {
    }
}

