/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.publish;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.thrift.TTopicItem;
import org.apache.doris.thrift.TTopicType;
import org.apache.doris.thrift.TTopicUpdate;

public class TopicUpdate {
    private final TTopicType type;
    private List<TTopicItem> updates;
    private List<String> deletes;

    public TopicUpdate(TTopicType type) {
        this.type = type;
    }

    public void addUpdates(TTopicItem update) {
        if (this.updates == null) {
            this.updates = Lists.newArrayList();
        }
        this.updates.add(update);
    }

    public void addDelete(String key) {
        if (this.deletes == null) {
            this.deletes = Lists.newArrayList();
        }
        this.deletes.add(key);
    }

    public TTopicUpdate toThrift() {
        TTopicUpdate tUpdate = new TTopicUpdate(this.type);
        if (this.updates != null) {
            tUpdate.setUpdates(this.updates);
        }
        if (this.deletes != null) {
            for (String toDelete : this.deletes) {
                tUpdate.addToDeletes(toDelete);
            }
        }
        return tUpdate;
    }
}

