/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.publish;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.doris.system.Backend;

public class ResponseHandler {
    private Set<Backend> nodes;
    private CountDownLatch latch;

    public ResponseHandler(Collection<Backend> nodes) {
        this.nodes = Sets.newConcurrentHashSet(nodes);
        this.latch = new CountDownLatch(nodes.size());
    }

    public void onResponse(Backend node) {
        if (this.nodes.remove(node)) {
            this.latch.countDown();
        }
    }

    public void onFailure(Backend node, Throwable t) {
        if (this.nodes.remove(node)) {
            this.latch.countDown();
        }
    }

    public boolean awaitAllInMs(long millions) throws InterruptedException {
        return this.latch.await(millions, TimeUnit.MILLISECONDS);
    }

    public Backend[] pendingNodes() {
        return this.nodes.toArray(new Backend[0]);
    }
}

