/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.publish;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.common.publish.TopicUpdate;
import org.apache.doris.thrift.TAgentPublishRequest;
import org.apache.doris.thrift.TAgentServiceVersion;

public class ClusterStateUpdate {
    private final List<TopicUpdate> updates;

    private ClusterStateUpdate(List<TopicUpdate> updates) {
        this.updates = updates;
    }

    public TAgentPublishRequest toThrift() {
        TAgentPublishRequest request = new TAgentPublishRequest();
        request.setProtocolVersion(TAgentServiceVersion.V1);
        for (TopicUpdate update : this.updates) {
            request.addToUpdates(update.toThrift());
        }
        return request;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<TopicUpdate> updates = Lists.newArrayList();

        public Builder addUpdate(TopicUpdate update) {
            this.updates.add(update);
            return this;
        }

        public ClusterStateUpdate build() {
            return new ClusterStateUpdate(this.updates);
        }
    }
}

