/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.publish;

import com.google.common.collect.ImmutableCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.publish.AckResponseHandler;
import org.apache.doris.common.publish.ClusterStateUpdate;
import org.apache.doris.common.publish.Listener;
import org.apache.doris.common.publish.ResponseHandler;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TAgentPublishRequest;
import org.apache.doris.thrift.TAgentResult;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class ClusterStatePublisher {
    private static final Logger LOG = LogManager.getLogger(ClusterStatePublisher.class);
    private static volatile ClusterStatePublisher INSTANCE;
    private ExecutorService executor = ThreadPoolManager.newDaemonFixedThreadPool(5, 256, "cluster-state-publisher", true);
    private SystemInfoService clusterInfoService;

    public ClusterStatePublisher(SystemInfoService clusterInfoService) {
        this.clusterInfoService = clusterInfoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterStatePublisher getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ClusterStatePublisher> clazz = ClusterStatePublisher.class;
        synchronized (ClusterStatePublisher.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ClusterStatePublisher(Catalog.getCurrentSystemInfo());
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void publish(ClusterStateUpdate state, Listener listener, int timeoutMs) {
        ImmutableCollection nodesToPublish = this.clusterInfoService.getIdToBackend().values();
        AckResponseHandler handler = new AckResponseHandler((Collection<Backend>)nodesToPublish, listener);
        for (Backend node : nodesToPublish) {
            this.executor.submit(new PublishWorker(state, node, handler));
        }
        try {
            Object[] backends;
            if (!handler.awaitAllInMs(timeoutMs) && (backends = handler.pendingNodes()).length > 0) {
                LOG.warn("timed out waiting for all nodes to publish. (pending nodes: {})", (Object)Arrays.toString(backends));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public class PublishWorker
    implements Runnable {
        private ClusterStateUpdate stateUpdate;
        private Backend node;
        private ResponseHandler handler;

        public PublishWorker(ClusterStateUpdate stateUpdate, Backend node, ResponseHandler handler) {
            this.stateUpdate = stateUpdate;
            this.node = node;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TNetworkAddress addr = new TNetworkAddress(this.node.getHost(), this.node.getBePort());
            BackendService.Client client = null;
            try {
                client = ClientPool.backendPool.borrowObject(addr);
            }
            catch (Exception e) {
                LOG.warn("Fetch a agent client failed. backend=[{}] reason=[{}]", (Object)addr, (Object)e);
                this.handler.onFailure(this.node, e);
                return;
            }
            try {
                TAgentPublishRequest request = this.stateUpdate.toThrift();
                TAgentResult tAgentResult = null;
                try {
                    tAgentResult = client.publishClusterState(request);
                }
                catch (TException e) {
                    if (!ClientPool.backendPool.reopen(client)) {
                        throw e;
                    }
                    tAgentResult = client.publishClusterState(request);
                }
                if (tAgentResult.getStatus().getStatusCode() != TStatusCode.OK) {
                    LOG.warn("Backend execute publish failed. backend=[{}], message=[{}]", (Object)addr, (Object)tAgentResult.getStatus().getErrorMsgs());
                }
                LOG.debug("Success publish to backend([{}])", (Object)addr);
                this.handler.onResponse(this.node);
            }
            catch (TException e) {
                LOG.warn("A thrift exception happened when publish to a backend. backend=[{}], reason=[{}]", (Object)addr, (Object)e);
                this.handler.onFailure(this.node, e);
                ClientPool.backendPool.invalidateObject(addr, client);
                client = null;
            }
            finally {
                ClientPool.backendPool.returnObject(addr, client);
            }
        }
    }
}

