/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.profile;

import com.google.common.base.Strings;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.profile.CounterNode;
import org.apache.doris.common.profile.ProfileTreePrinter;

public class ProfileTreeNode
extends TreeNode<ProfileTreeNode> {
    protected String name;
    protected String id;
    protected CounterNode counterNode;
    protected String activeTime;
    protected String nonChild;
    protected String fragmentId = "";
    protected String instanceId = "";
    protected String maxInstanceActiveTime = "";
    protected ProfileTreeNode parentNode;

    protected ProfileTreeNode(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public void setParentNode(ProfileTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public ProfileTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setCounterNode(CounterNode counterNode) {
        this.counterNode = counterNode;
    }

    public CounterNode getCounterNode() {
        return this.counterNode;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setActiveTime(String activeTime) {
        this.activeTime = activeTime;
    }

    public String getActiveTime() {
        return this.activeTime;
    }

    public void setNonChild(String nonChild) {
        this.nonChild = nonChild;
    }

    public String getNonChild() {
        return this.nonChild;
    }

    public String getIdentity() {
        if (this.id.equals("-2")) {
            return "[" + this.name + "]";
        }
        return "[" + this.id + ": " + this.name + "]";
    }

    public void setFragmentAndInstanceId(String fragmentId, String instanceId) {
        this.fragmentId = fragmentId;
        this.instanceId = instanceId;
    }

    public void setMaxInstanceActiveTime(String maxInstanceActiveTime) {
        this.maxInstanceActiveTime = maxInstanceActiveTime;
    }

    public String getMaxInstanceActiveTime() {
        return this.maxInstanceActiveTime;
    }

    public String debugTree(int indent, ProfileTreePrinter.PrintLevel level) {
        StringBuilder sb = new StringBuilder(this.printIndent(indent));
        sb.append(this.debugString(indent, level));
        if (!this.getChildren().isEmpty()) {
            int childSize = this.getChildren().size();
            for (int i = 0; i < childSize; ++i) {
                ProfileTreeNode node = (ProfileTreeNode)this.getChild(i);
                sb.append("\n").append(node.debugTree(indent + 4, level));
            }
        }
        return sb.toString();
    }

    public String debugString(int indent, ProfileTreePrinter.PrintLevel level) {
        String indentStr = this.printIndent(indent);
        StringBuilder sb = new StringBuilder();
        sb.append(indentStr).append(this.getIdentity()).append("\n");
        if (level == ProfileTreePrinter.PrintLevel.FRAGMENT) {
            sb.append(indentStr).append("Fragment: ").append(this.fragmentId).append("\n");
            if (!Strings.isNullOrEmpty((String)this.maxInstanceActiveTime)) {
                sb.append(indentStr).append("MaxActiveTime: ").append(this.maxInstanceActiveTime).append("\n");
            }
        }
        if (level == ProfileTreePrinter.PrintLevel.INSTANCE) {
            sb.append("(Active: ").append(this.activeTime).append(", ");
            sb.append("non-child: ").append(this.nonChild).append(")").append("\n");
            sb.append(this.counterNode.toTree(indent + 1));
        }
        return sb.toString();
    }

    private String printIndent(int indent) {
        String res = "";
        for (int i = 0; i < indent; ++i) {
            res = res + " ";
        }
        return res;
    }
}

