/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.profile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.common.Pair;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.UserException;
import org.apache.doris.common.profile.CounterNode;
import org.apache.doris.common.profile.ExecNodeNode;
import org.apache.doris.common.profile.ProfileTreeNode;
import org.apache.doris.common.util.Counter;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.thrift.TUnit;

public class ProfileTreeBuilder {
    private static final String PROFILE_NAME_DATA_STREAM_SENDER = "DataStreamSender";
    private static final String PROFILE_NAME_VDATA_STREAM_SENDER = "VDataStreamSender";
    private static final String PROFILE_NAME_DATA_BUFFER_SENDER = "DataBufferSender";
    private static final String PROFILE_NAME_VDATA_BUFFER_SENDER = "VDataBufferSender";
    private static final String PROFILE_NAME_OLAP_TABLE_SINK = "OlapTableSink";
    private static final String PROFILE_NAME_BLOCK_MGR = "BlockMgr";
    private static final String PROFILE_NAME_BUFFER_POOL = "Buffer pool";
    private static final String PROFILE_NAME_EXCHANGE_NODE = "EXCHANGE_NODE";
    public static final String FINAL_SENDER_ID = "-1";
    private static final String PROFILE_NAME_VEXCHANGE_NODE = "VEXCHANGE_NODE";
    public static final String DATA_BUFFER_SENDER_ID = "-1";
    public static final String UNKNOWN_ID = "-2";
    private RuntimeProfile profileRoot;
    private List<ProfileTreeNode> exchangeNodes = Lists.newArrayList();
    private List<ProfileTreeNode> senderNodes = Lists.newArrayList();
    private Map<String, Map<String, ProfileTreeNode>> instanceTreeMap = Maps.newHashMap();
    private Map<String, List<Triple<String, String, Long>>> instanceActiveTimeMap = Maps.newHashMap();
    private ProfileTreeNode fragmentTreeRoot;
    private List<FragmentInstances> fragmentsInstances = Lists.newArrayList();
    private static final String EXEC_NODE_NAME_ID_PATTERN_STR = "^(.*) .*id=([0-9]+).*";
    private static final Pattern EXEC_NODE_NAME_ID_PATTERN = Pattern.compile("^(.*) .*id=([0-9]+).*");
    private static final String FRAGMENT_ID_PATTERN_STR = "^Fragment ([0-9]+).*";
    private static final Pattern FRAGMENT_ID_PATTERN = Pattern.compile("^Fragment ([0-9]+).*");
    private static final String INSTANCE_PATTERN_STR = "^Instance (.*) \\(.*hostname:(.*), port:([0-9]+).*";
    private static final Pattern INSTANCE_PATTERN = Pattern.compile("^Instance (.*) \\(.*hostname:(.*), port:([0-9]+).*");

    public ProfileTreeBuilder(RuntimeProfile root) {
        this.profileRoot = root;
    }

    public ProfileTreeNode getFragmentTreeRoot() {
        return this.fragmentTreeRoot;
    }

    public ProfileTreeNode getInstanceTreeRoot(String fragmentId, String instanceId) {
        if (!this.instanceTreeMap.containsKey(fragmentId)) {
            return null;
        }
        return this.instanceTreeMap.get(fragmentId).get(instanceId);
    }

    public List<Triple<String, String, Long>> getInstanceList(String fragmentId) {
        return this.instanceActiveTimeMap.get(fragmentId);
    }

    public List<FragmentInstances> getFragmentsInstances() {
        return this.fragmentsInstances;
    }

    public void build() throws UserException {
        this.reset();
        this.checkProfile();
        this.analyzeAndBuildFragmentTrees();
        this.assembleFragmentTrees();
    }

    private void reset() {
        this.exchangeNodes.clear();
        this.senderNodes.clear();
        this.instanceTreeMap.clear();
        this.instanceActiveTimeMap.clear();
        this.fragmentTreeRoot = null;
        this.fragmentsInstances.clear();
    }

    private void checkProfile() throws UserException {
        if (!this.profileRoot.getName().startsWith("Execution Profile")) {
            throw new UserException("Invalid profile. Expected Execution Profile");
        }
    }

    private void analyzeAndBuildFragmentTrees() throws UserException {
        List<Pair<RuntimeProfile, Boolean>> childrenFragment = this.profileRoot.getChildList();
        for (Pair<RuntimeProfile, Boolean> pair : childrenFragment) {
            this.analyzeAndBuildFragmentTree((RuntimeProfile)pair.first);
        }
    }

    private void analyzeAndBuildFragmentTree(RuntimeProfile fragmentProfile) throws UserException {
        String fragmentId = this.getFragmentId(fragmentProfile);
        List<Pair<RuntimeProfile, Boolean>> fragmentChildren = fragmentProfile.getChildList();
        if (fragmentChildren.isEmpty()) {
            throw new UserException("Empty instance in fragment: " + fragmentProfile.getName());
        }
        ArrayList instanceIdAndActiveTimeList = Lists.newArrayList();
        ArrayList instances = Lists.newArrayList();
        HashMap instanceIdToTime = Maps.newHashMap();
        long maxActiveTimeNs = 0L;
        for (Pair<RuntimeProfile, Boolean> pair : fragmentChildren) {
            Triple<String, String, Long> instanceIdAndActiveTime = this.getInstanceIdHostAndActiveTime((RuntimeProfile)pair.first);
            instanceIdToTime.put((String)instanceIdAndActiveTime.getLeft(), RuntimeProfile.printCounter((Long)instanceIdAndActiveTime.getRight(), TUnit.TIME_NS));
            maxActiveTimeNs = Math.max((Long)instanceIdAndActiveTime.getRight(), maxActiveTimeNs);
            instanceIdAndActiveTimeList.add(instanceIdAndActiveTime);
            instances.add((String)instanceIdAndActiveTime.getLeft());
        }
        this.instanceActiveTimeMap.put(fragmentId, instanceIdAndActiveTimeList);
        this.fragmentsInstances.add(new FragmentInstances(fragmentId, RuntimeProfile.printCounter(maxActiveTimeNs, TUnit.TIME_NS), instanceIdToTime));
        RuntimeProfile instanceProfile = (RuntimeProfile)fragmentChildren.get((int)0).first;
        ProfileTreeNode instanceTreeRoot = this.buildSingleInstanceTree(instanceProfile, fragmentId, null);
        instanceTreeRoot.setMaxInstanceActiveTime(RuntimeProfile.printCounter(maxActiveTimeNs, TUnit.TIME_NS));
        if (instanceTreeRoot.id.equals("-1")) {
            this.fragmentTreeRoot = instanceTreeRoot;
        }
        int i = 0;
        HashMap instanceTrees = Maps.newHashMap();
        for (Pair<RuntimeProfile, Boolean> pair : fragmentChildren) {
            String instanceId = (String)((Triple)instanceIdAndActiveTimeList.get(i)).getLeft();
            ProfileTreeNode singleInstanceTreeNode = this.buildSingleInstanceTree((RuntimeProfile)pair.first, fragmentId, instanceId);
            instanceTrees.put(instanceId, singleInstanceTreeNode);
            ++i;
        }
        this.instanceTreeMap.put(fragmentId, instanceTrees);
    }

    private ProfileTreeNode buildSingleInstanceTree(RuntimeProfile instanceProfile, String fragmentId, String instanceId) throws UserException {
        List<Pair<RuntimeProfile, Boolean>> instanceChildren = instanceProfile.getChildList();
        TreeNode senderNode = null;
        ProfileTreeNode execNode = null;
        for (Pair<RuntimeProfile, Boolean> pair : instanceChildren) {
            RuntimeProfile profile = (RuntimeProfile)pair.first;
            if (profile.getName().startsWith(PROFILE_NAME_DATA_STREAM_SENDER) || profile.getName().startsWith(PROFILE_NAME_VDATA_STREAM_SENDER) || profile.getName().startsWith(PROFILE_NAME_VDATA_BUFFER_SENDER) || profile.getName().startsWith(PROFILE_NAME_DATA_BUFFER_SENDER) || profile.getName().startsWith(PROFILE_NAME_OLAP_TABLE_SINK)) {
                senderNode = this.buildTreeNode(profile, null, fragmentId, instanceId);
                if (instanceId != null) continue;
                this.senderNodes.add((ProfileTreeNode)senderNode);
                continue;
            }
            if (profile.getName().startsWith(PROFILE_NAME_BLOCK_MGR) || profile.getName().startsWith(PROFILE_NAME_BUFFER_POOL)) continue;
            execNode = this.buildTreeNode(profile, null, fragmentId, instanceId);
        }
        if (senderNode == null || execNode == null) {
            throw new UserException("Invalid instance profile, without sender or exec node: " + instanceProfile);
        }
        senderNode.addChild(execNode);
        execNode.setParentNode((ProfileTreeNode)senderNode);
        ((ProfileTreeNode)senderNode).setFragmentAndInstanceId(fragmentId, instanceId);
        execNode.setFragmentAndInstanceId(fragmentId, instanceId);
        return senderNode;
    }

    private ProfileTreeNode buildTreeNode(RuntimeProfile profile, ProfileTreeNode root, String fragmentId, String instanceId) {
        String extractId;
        String extractName;
        String name = profile.getName();
        if (name.startsWith(PROFILE_NAME_BUFFER_POOL)) {
            return null;
        }
        String finalSenderName = this.checkAndGetFinalSenderName(name);
        Matcher m = EXEC_NODE_NAME_ID_PATTERN.matcher(name);
        if (!m.find() && finalSenderName == null || m.groupCount() != 2) {
            extractName = name;
            extractId = UNKNOWN_ID;
        } else {
            extractName = finalSenderName != null ? finalSenderName : m.group(1);
            extractId = finalSenderName != null ? "-1" : m.group(2);
        }
        Counter activeCounter = profile.getCounterTotalTime();
        ExecNodeNode node = new ExecNodeNode(extractName, extractId);
        node.setActiveTime(RuntimeProfile.printCounter(activeCounter.getValue(), activeCounter.getType()));
        try (Formatter fmt = new Formatter();){
            node.setNonChild(fmt.format("%.2f", profile.getLocalTimePercent()).toString());
        }
        CounterNode rootCounterNode = new CounterNode();
        this.buildCounterNode(profile, RuntimeProfile.ROOT_COUNTER, rootCounterNode);
        node.setCounterNode(rootCounterNode);
        if (root != null) {
            root.addChild(node);
            node.setParentNode(root);
        }
        if ((node.name.equals(PROFILE_NAME_EXCHANGE_NODE) || node.name.equals(PROFILE_NAME_VEXCHANGE_NODE)) && instanceId == null) {
            this.exchangeNodes.add(node);
        }
        List<Pair<RuntimeProfile, Boolean>> children = profile.getChildList();
        for (int i = children.size() - 1; i >= 0; --i) {
            Pair<RuntimeProfile, Boolean> pair = children.get(i);
            ProfileTreeNode execNode = this.buildTreeNode((RuntimeProfile)pair.first, node, fragmentId, instanceId);
            if (execNode == null) continue;
            execNode.setFragmentAndInstanceId(fragmentId, instanceId);
        }
        return node;
    }

    private String checkAndGetFinalSenderName(String name) {
        if (name.startsWith(PROFILE_NAME_DATA_BUFFER_SENDER)) {
            return PROFILE_NAME_DATA_BUFFER_SENDER;
        }
        if (name.startsWith(PROFILE_NAME_OLAP_TABLE_SINK)) {
            return PROFILE_NAME_OLAP_TABLE_SINK;
        }
        if (name.startsWith(PROFILE_NAME_VDATA_BUFFER_SENDER)) {
            return PROFILE_NAME_VDATA_BUFFER_SENDER;
        }
        return null;
    }

    private void buildCounterNode(RuntimeProfile profile, String counterName, CounterNode root) {
        Map<String, TreeSet<String>> childCounterMap = profile.getChildCounterMap();
        Set childCounterSet = childCounterMap.get(counterName);
        if (childCounterSet == null) {
            return;
        }
        Map<String, Counter> counterMap = profile.getCounterMap();
        for (String childCounterName : childCounterSet) {
            Counter counter = counterMap.get(childCounterName);
            CounterNode counterNode = new CounterNode();
            if (root != null) {
                root.addChild(counterNode);
            }
            counterNode.setCounter(childCounterName, RuntimeProfile.printCounter(counter.getValue(), counter.getType()));
            this.buildCounterNode(profile, childCounterName, counterNode);
        }
    }

    private void assembleFragmentTrees() throws UserException {
        for (ProfileTreeNode senderNode : this.senderNodes) {
            if (senderNode.id.equals("-1")) continue;
            ProfileTreeNode exchangeNode = this.findExchangeNode(senderNode.id);
            exchangeNode.addChild(senderNode);
            senderNode.setParentNode(exchangeNode);
        }
    }

    private ProfileTreeNode findExchangeNode(String senderId) throws UserException {
        for (ProfileTreeNode node : this.exchangeNodes) {
            if (!node.id.equals(senderId)) continue;
            return node;
        }
        throw new UserException("Failed to find fragment for sender id: " + senderId);
    }

    private String getFragmentId(RuntimeProfile fragmentProfile) throws UserException {
        String name = fragmentProfile.getName();
        Matcher m = FRAGMENT_ID_PATTERN.matcher(name);
        if (!m.find() || m.groupCount() != 1) {
            throw new UserException("Invalid fragment profile name: " + name);
        }
        return m.group(1);
    }

    private Triple<String, String, Long> getInstanceIdHostAndActiveTime(RuntimeProfile instanceProfile) throws UserException {
        long activeTimeNs = instanceProfile.getCounterTotalTime().getValue();
        String name = instanceProfile.getName();
        Matcher m = INSTANCE_PATTERN.matcher(name);
        if (!m.find() || m.groupCount() != 3) {
            throw new UserException("Invalid instance profile name: " + name);
        }
        return new ImmutableTriple((Object)m.group(1), (Object)(m.group(2) + ":" + m.group(3)), (Object)activeTimeNs);
    }

    public static class FragmentInstances {
        @JsonProperty(value="fragment_id")
        private String fragmentId;
        @JsonProperty(value="time")
        private String maxActiveTimeNs;
        @JsonProperty(value="instance_id")
        private Map<String, String> instanceIdToTime;

        public FragmentInstances(String fragmentId, String maxActiveTimeNs, Map<String, String> instanceIdToTime) {
            this.fragmentId = fragmentId;
            this.maxActiveTimeNs = maxActiveTimeNs;
            this.instanceIdToTime = instanceIdToTime;
        }

        public String getFragmentId() {
            return this.fragmentId;
        }

        public String getMaxActiveTimeNs() {
            return this.maxActiveTimeNs;
        }

        public Map<String, String> getInstanceIdToTime() {
            return this.instanceIdToTime;
        }

        @JsonProperty(value="fragment_id")
        public void setFragmentId(String fragmentId) {
            this.fragmentId = fragmentId;
        }

        @JsonProperty(value="time")
        public void setMaxActiveTimeNs(String maxActiveTimeNs) {
            this.maxActiveTimeNs = maxActiveTimeNs;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceIdToTime(Map<String, String> instanceIdToTime) {
            this.instanceIdToTime = instanceIdToTime;
        }
    }
}

