/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.profile;

import com.clearspring.analytics.util.Lists;
import java.util.List;
import org.apache.doris.common.UserException;
import org.apache.doris.common.profile.PlanTreeNode;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;

public class PlanTreeBuilder {
    private List<PlanFragment> fragments;
    private PlanTreeNode treeRoot;
    private List<PlanTreeNode> sinkNodes = Lists.newArrayList();
    private List<PlanTreeNode> exchangeNodes = Lists.newArrayList();

    public PlanTreeBuilder(List<PlanFragment> fragments) {
        this.fragments = fragments;
    }

    public PlanTreeNode getTreeRoot() {
        return this.treeRoot;
    }

    public void build() throws UserException {
        this.buildFragmentPlans();
        this.assembleFragmentPlans();
    }

    private void buildFragmentPlans() {
        int i = 0;
        for (PlanFragment fragment : this.fragments) {
            PlanNode planRoot;
            DataSink sink = fragment.getSink();
            PlanTreeNode sinkNode = null;
            if (sink != null) {
                StringBuilder sb = new StringBuilder();
                if (sink.getExchNodeId() != null) {
                    sb.append("[").append(sink.getExchNodeId().asInt()).append(": ").append(sink.getClass().getSimpleName()).append("]");
                } else {
                    sb.append("[").append(sink.getClass().getSimpleName()).append("]");
                }
                sb.append("\n[Fragment: ").append(fragment.getId().asInt()).append("]");
                sb.append("\n").append(sink.getExplainString("", TExplainLevel.BRIEF));
                sinkNode = new PlanTreeNode(sink.getExchNodeId(), sb.toString());
                if (i == 0) {
                    this.treeRoot = sinkNode;
                } else {
                    this.sinkNodes.add(sinkNode);
                }
            }
            if ((planRoot = fragment.getPlanRoot()) != null) {
                this.buildForPlanNode(planRoot, sinkNode);
            }
            ++i;
        }
    }

    private void assembleFragmentPlans() throws UserException {
        for (PlanTreeNode sender : this.sinkNodes) {
            if (sender == this.treeRoot) continue;
            PlanNodeId senderId = sender.getId();
            PlanTreeNode exchangeNode = this.findExchangeNode(senderId);
            if (exchangeNode == null) {
                throw new UserException("Failed to find exchange node for sender id: " + senderId.asInt());
            }
            exchangeNode.addChild(sender);
        }
    }

    private PlanTreeNode findExchangeNode(PlanNodeId senderId) {
        for (PlanTreeNode exchangeNode : this.exchangeNodes) {
            if (!exchangeNode.getId().equals(senderId)) continue;
            return exchangeNode;
        }
        return null;
    }

    private void buildForPlanNode(PlanNode planNode, PlanTreeNode parent) {
        PlanTreeNode node = new PlanTreeNode(planNode.getId(), planNode.getPlanTreeExplainStr());
        if (parent != null) {
            parent.addChild(node);
        }
        if (planNode.getPlanNodeName().contains("EXCHANGE")) {
            this.exchangeNodes.add(node);
        } else {
            for (PlanNode child : planNode.getChildren()) {
                this.buildForPlanNode(child, node);
            }
        }
    }
}

