/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.profile;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.profile.ProfileTreeBuilder;
import org.apache.doris.common.profile.ProfileTreeNode;
import org.apache.doris.common.util.Counter;
import org.apache.doris.common.util.RuntimeProfile;

public class MultiProfileTreeBuilder {
    private static final Set<String> PROFILE_ROOT_NAMES = Sets.newHashSet();
    public static final String PROFILE_NAME_EXECUTION = "Execution Profile";
    private static final String EXECUTION_ID_PATTERN_STR = "^Execution Profile (.*)";
    private static final Pattern EXECUTION_ID_PATTERN;
    private RuntimeProfile profileRoot;
    private Map<String, RuntimeProfile> idToSingleProfile = Maps.newHashMap();
    private Map<String, ProfileTreeBuilder> idToSingleTreeBuilder = Maps.newHashMap();

    public MultiProfileTreeBuilder(RuntimeProfile root) {
        this.profileRoot = root;
    }

    public void build() throws UserException {
        this.unwrapProfile();
        this.buildTrees();
    }

    private void unwrapProfile() throws UserException {
        if (PROFILE_ROOT_NAMES.stream().anyMatch(n -> this.profileRoot.getName().startsWith((String)n))) {
            List<Pair<RuntimeProfile, Boolean>> children = this.profileRoot.getChildList();
            boolean find = false;
            for (Pair<RuntimeProfile, Boolean> pair : children) {
                if (!((RuntimeProfile)pair.first).getName().startsWith(PROFILE_NAME_EXECUTION)) continue;
                String executionProfileId = this.getExecutionProfileId(((RuntimeProfile)pair.first).getName());
                this.idToSingleProfile.put(executionProfileId, (RuntimeProfile)pair.first);
                find = true;
            }
            if (!find) {
                throw new UserException("Invalid profile. Expected Execution Profile");
            }
        }
    }

    private String getExecutionProfileId(String executionName) throws UserException {
        Matcher m = EXECUTION_ID_PATTERN.matcher(executionName);
        if (!m.find() || m.groupCount() != 1) {
            throw new UserException("Invalid execution profile name: " + executionName);
        }
        return m.group(1);
    }

    private void buildTrees() throws UserException {
        for (Map.Entry<String, RuntimeProfile> entry : this.idToSingleProfile.entrySet()) {
            ProfileTreeBuilder builder = new ProfileTreeBuilder(entry.getValue());
            builder.build();
            this.idToSingleTreeBuilder.put(entry.getKey(), builder);
        }
    }

    public List<List<String>> getSubTaskInfo() {
        List rows = Lists.newArrayList();
        for (Map.Entry<String, RuntimeProfile> entry : this.idToSingleProfile.entrySet()) {
            List row = Lists.newArrayList();
            Counter activeCounter = entry.getValue().getCounterTotalTime();
            row.add(entry.getKey());
            row.add(RuntimeProfile.printCounter(activeCounter.getValue(), activeCounter.getType()));
            rows.add(row);
        }
        return rows;
    }

    public List<Triple<String, String, Long>> getInstanceList(String executionId, String fragmentId) throws AnalysisException {
        ProfileTreeBuilder singleBuilder = this.getExecutionProfileTreeBuilder(executionId);
        return singleBuilder.getInstanceList(fragmentId);
    }

    public ProfileTreeNode getInstanceTreeRoot(String executionId, String fragmentId, String instanceId) throws AnalysisException {
        ProfileTreeBuilder singleBuilder = this.getExecutionProfileTreeBuilder(executionId);
        return singleBuilder.getInstanceTreeRoot(fragmentId, instanceId);
    }

    public ProfileTreeNode getFragmentTreeRoot(String executionId) throws AnalysisException {
        ProfileTreeBuilder singleBuilder = this.getExecutionProfileTreeBuilder(executionId);
        return singleBuilder.getFragmentTreeRoot();
    }

    public List<ProfileTreeBuilder.FragmentInstances> getFragmentInstances(String executionId) throws AnalysisException {
        return this.getExecutionProfileTreeBuilder(executionId).getFragmentsInstances();
    }

    private ProfileTreeBuilder getExecutionProfileTreeBuilder(String executionId) throws AnalysisException {
        ProfileTreeBuilder singleBuilder = this.idToSingleTreeBuilder.get(executionId);
        if (singleBuilder == null) {
            throw new AnalysisException("Can not find execution profile: " + executionId);
        }
        return singleBuilder;
    }

    static {
        PROFILE_ROOT_NAMES.add("Query");
        PROFILE_ROOT_NAMES.add("BrokerLoadJob");
        EXECUTION_ID_PATTERN = Pattern.compile(EXECUTION_ID_PATTERN_STR);
    }
}

