/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.profile;

import org.apache.doris.common.Pair;
import org.apache.doris.common.TreeNode;

public class CounterNode
extends TreeNode<CounterNode> {
    private Pair<String, String> counter;

    public void setCounter(String key, String value) {
        this.counter = Pair.create(key, value);
    }

    public String toTree(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.debugString(indent));
        for (CounterNode node : this.getChildren()) {
            sb.append("\n").append(node.debugString(indent + 4));
        }
        return sb.toString();
    }

    public String debugString(int indent) {
        if (this.counter == null) {
            return this.printIndent(indent) + " - Counters:";
        }
        return this.printIndent(indent) + " - " + (String)this.counter.first + ": " + (String)this.counter.second;
    }

    private String printIndent(int indent) {
        String res = "";
        for (int i = 0; i < indent; ++i) {
            res = res + " ";
        }
        return res;
    }
}

