/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TDiskTrashInfo;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashProcNode
implements ProcNodeInterface {
    private static final Logger LOG = LogManager.getLogger(TrashProcNode.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"RootPath").add((Object)"State").add((Object)"TrashUsedCapacity").build();
    private Backend backend;

    public TrashProcNode(Backend backend) {
        this.backend = backend;
    }

    @Override
    public ProcResult fetchResult() {
        Preconditions.checkNotNull((Object)this.backend);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        ArrayList infos = Lists.newArrayList();
        TrashProcNode.getTrashDiskInfo(this.backend, infos);
        for (List info : infos) {
            result.addRow(info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTrashDiskInfo(Backend backend, List<List<String>> infos) {
        BackendService.Client client = null;
        TNetworkAddress address = null;
        boolean ok = false;
        List diskTrashInfos = null;
        try {
            address = new TNetworkAddress(backend.getHost(), backend.getBePort());
            client = ClientPool.backendPool.borrowObject(address);
            diskTrashInfos = client.getDiskTrashUsedCapacity();
            ok = true;
            if (ok) {
                ClientPool.backendPool.returnObject(address, client);
            } else {
                ClientPool.backendPool.invalidateObject(address, client);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("task exec error. backend[{}]", (Object)backend.getId(), (Object)e);
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, client);
                }
            }
            catch (Throwable throwable) {
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, client);
                }
                throw throwable;
            }
        }
        if (diskTrashInfos == null) {
            return;
        }
        for (TDiskTrashInfo diskTrashInfo : diskTrashInfos) {
            ArrayList<String> diskInfo = new ArrayList<String>();
            diskInfo.add(diskTrashInfo.getRootPath());
            diskInfo.add(diskTrashInfo.getState());
            long trashUsedCapacityB = diskTrashInfo.getTrashUsedCapacity();
            Pair<Double, String> trashUsedCapacity = DebugUtil.getByteUint(trashUsedCapacityB);
            diskInfo.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(trashUsedCapacity.first) + " " + (String)trashUsedCapacity.second);
            infos.add(diskInfo);
        }
    }
}

