/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TrashProcNode;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashProcDir
implements ProcDirInterface {
    private static final Logger LOG = LogManager.getLogger(TrashProcNode.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BackendId").add((Object)"Backend").add((Object)"TrashUsedCapacity").build();
    private List<Backend> backends = Lists.newArrayList();

    public TrashProcDir() {
        ImmutableMap<Long, Backend> backendsInfo = Catalog.getCurrentSystemInfo().getIdToBackend();
        for (Backend backend : backendsInfo.values()) {
            this.backends.add(backend);
        }
    }

    @Override
    public ProcResult fetchResult() {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        ArrayList infos = Lists.newArrayList();
        TrashProcDir.getTrashInfo(this.backends, infos);
        for (List info : infos) {
            result.addRow(info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTrashInfo(List<Backend> backends, List<List<String>> infos) {
        for (Backend backend : backends) {
            BackendService.Client client = null;
            TNetworkAddress address = null;
            Long trashUsedCapacityB = null;
            boolean ok = false;
            try {
                long start = System.currentTimeMillis();
                address = new TNetworkAddress(backend.getHost(), backend.getBePort());
                client = ClientPool.backendPool.borrowObject(address);
                trashUsedCapacityB = client.getTrashUsedCapacity();
                ok = true;
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, client);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("task exec error. backend[{}]", (Object)backend.getId(), (Object)e);
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                }
                catch (Throwable throwable) {
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                    throw throwable;
                }
            }
            ArrayList<String> backendInfo = new ArrayList<String>();
            backendInfo.add(String.valueOf(backend.getId()));
            backendInfo.add(backend.getHost() + ":" + backend.getHeartbeatPort());
            if (trashUsedCapacityB != null) {
                Pair<Double, String> trashUsedCapacity = DebugUtil.getByteUint(trashUsedCapacityB);
                backendInfo.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(trashUsedCapacity.first) + " " + (String)trashUsedCapacity.second);
            } else {
                backendInfo.add("");
            }
            infos.add(backendInfo);
        }
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String backendIdStr) throws AnalysisException {
        long backendId = -1L;
        try {
            backendId = Long.parseLong(backendIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid backend id format: " + backendIdStr);
        }
        Backend backend = Catalog.getCurrentSystemInfo().getBackend(backendId);
        if (backend == null) {
            throw new AnalysisException("Backend[" + backendId + "] does not exist.");
        }
        return new TrashProcNode(backend);
    }
}

