/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TransProcDir;
import org.apache.doris.transaction.GlobalTransactionMgr;

public class TransStateProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"State").add((Object)"Number").build();
    private long dbId;

    public TransStateProcDir(Long dbId) {
        this.dbId = dbId;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        GlobalTransactionMgr transactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        result.setRows(transactionMgr.getDbTransStateInfo(this.dbId));
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String state) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)state)) {
            throw new AnalysisException("State is not set");
        }
        if (!state.equals("running") && !state.equals("finished")) {
            throw new AnalysisException("State is invalid");
        }
        return new TransProcDir(this.dbId, state);
    }
}

