/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TransTablesProcDir;
import org.apache.doris.transaction.GlobalTransactionMgr;

public class TransProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TransactionId").add((Object)"Label").add((Object)"Coordinator").add((Object)"TransactionStatus").add((Object)"LoadJobSourceType").add((Object)"PrepareTime").add((Object)"PreCommitTime").add((Object)"CommitTime").add((Object)"PublishTime").add((Object)"FinishTime").add((Object)"Reason").add((Object)"ErrorReplicasCount").add((Object)"ListenerId").add((Object)"TimeoutMs").add((Object)"ErrMsg").build();
    public static final int MAX_SHOW_ENTRIES = 2000;
    private long dbId;
    private String state;

    public TransProcDir(long dbId, String state) {
        this.dbId = dbId;
        this.state = state;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        GlobalTransactionMgr transactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        List<List<String>> infos = transactionMgr.getDbTransInfo(this.dbId, this.state.equals("running"), 2000);
        result.setRows(infos);
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String tidStr) throws AnalysisException {
        if (tidStr == null || Strings.isNullOrEmpty((String)tidStr)) {
            throw new AnalysisException("Table id is null");
        }
        long tid = -1L;
        try {
            tid = Long.valueOf(tidStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid transaction id format: " + tid);
        }
        return new TransTablesProcDir(this.dbId, tid);
    }
}

