/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TaskTypeProcNode;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.thrift.TTaskType;

public class TasksProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TaskType").add((Object)"FailedNum").add((Object)"TotalNum").build();

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String typeName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)typeName)) {
            throw new AnalysisException("type name is null");
        }
        TTaskType type = null;
        try {
            type = TTaskType.valueOf((String)typeName);
        }
        catch (Exception e) {
            throw new AnalysisException("invalid type name: " + typeName);
        }
        return new TaskTypeProcNode(type);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        int totalFailedNum = 0;
        int totalTaskNum = 0;
        for (TTaskType type : TTaskType.values()) {
            int failedNum = AgentTaskQueue.getTaskNum(-1L, type, true);
            int taskNum = AgentTaskQueue.getTaskNum(-1L, type, false);
            ArrayList row = Lists.newArrayList();
            row.add(type.name());
            row.add(String.valueOf(failedNum));
            row.add(String.valueOf(taskNum));
            result.addRow(row);
            totalFailedNum += failedNum;
            totalTaskNum += taskNum;
        }
        ArrayList sumRow = Lists.newArrayList();
        sumRow.add("Total");
        sumRow.add(String.valueOf(totalFailedNum));
        sumRow.add(String.valueOf(totalTaskNum));
        result.addRow(sumRow);
        return result;
    }
}

