/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TaskFailedProcNode;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.thrift.TTaskType;

public class TaskTypeProcNode
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BackendId").add((Object)"FailedNum").add((Object)"TotalNum").build();
    private TTaskType type;

    public TaskTypeProcNode(TTaskType type) {
        this.type = type;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        int totalFailedNum = 0;
        int totalTaskNum = 0;
        List<Long> backendIds = Catalog.getCurrentSystemInfo().getBackendIds(false);
        for (Long backendId : backendIds) {
            int failedNum = AgentTaskQueue.getTaskNum(backendId, this.type, true);
            int taskNum = AgentTaskQueue.getTaskNum(backendId, this.type, false);
            ArrayList row = Lists.newArrayList();
            row.add(backendId.toString());
            row.add(String.valueOf(failedNum));
            row.add(String.valueOf(taskNum));
            result.addRow(row);
            totalFailedNum += failedNum;
            totalTaskNum += taskNum;
        }
        ArrayList sumRow = Lists.newArrayList();
        sumRow.add("Total");
        sumRow.add(String.valueOf(totalFailedNum));
        sumRow.add(String.valueOf(totalTaskNum));
        result.addRow(sumRow);
        return result;
    }

    @Override
    public ProcNodeInterface lookup(String backendIdStr) throws AnalysisException {
        long backendId = -1L;
        try {
            backendId = Long.valueOf(backendIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid backend id format: " + backendIdStr);
        }
        return new TaskFailedProcNode(backendId, this.type);
    }
}

